/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.keyword.PartnersWithSearchEffect;
import mage.cards.Card;
import mage.target.TargetPlayer;

public class PartnerWithAbility
extends EntersBattlefieldTriggeredAbility {
    private final String partnerName;
    private final String shortName;
    private final boolean hasReminderText;

    public PartnerWithAbility(String partnerName) {
        this(partnerName, false);
    }

    public PartnerWithAbility(String partnerName, boolean isLegendary) {
        this(partnerName, isLegendary, true);
    }

    public PartnerWithAbility(String partnerName, boolean isLegendary, boolean hasReminderText) {
        super(new PartnersWithSearchEffect(partnerName), false);
        this.addTarget(new TargetPlayer());
        this.partnerName = partnerName;
        this.hasReminderText = hasReminderText;
        this.shortName = isLegendary ? PartnerWithAbility.shortenName(partnerName) : partnerName;
    }

    protected PartnerWithAbility(PartnerWithAbility ability) {
        super(ability);
        this.partnerName = ability.partnerName;
        this.shortName = ability.shortName;
        this.hasReminderText = ability.hasReminderText;
    }

    @Override
    public PartnerWithAbility copy() {
        return new PartnerWithAbility(this);
    }

    @Override
    public String getRule() {
        if (this.hasReminderText) {
            return "Partner with " + this.partnerName + " <i>(When this creature enters the battlefield, target player may put " + this.shortName + " into their hand from their library, then shuffle.)</i>";
        }
        return "Partner with " + this.partnerName;
    }

    public String getPartnerName() {
        return this.partnerName;
    }

    public boolean checkPartner(Card card) {
        return this.partnerName.equals(card.getName());
    }

    public static String shortenName(String st) {
        StringBuilder sb = new StringBuilder();
        for (char s : st.toCharArray()) {
            if (s == ' ' || s == ',') break;
            sb.append(s);
        }
        return sb.toString();
    }
}

