/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.GiftType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.util.CardUtil;

class PromiseGiftEffect
extends OneShotEffect {
    private final GiftType giftType;

    PromiseGiftEffect(GiftType giftType) {
        super(Outcome.Benefit);
        this.giftType = giftType;
        this.staticText = "they " + giftType.getDescription();
    }

    private PromiseGiftEffect(PromiseGiftEffect effect) {
        super(effect);
        this.giftType = effect.giftType;
    }

    @Override
    public PromiseGiftEffect copy() {
        return new PromiseGiftEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(CardUtil.getSourceCostsTag(game, source, "giftPromisedActivation", null));
        if (player != null && this.giftType.applyGift(player, game, source)) {
            game.fireEvent(GameEvent.getEvent(GameEvent.EventType.GAVE_GIFT, player.getId(), source, source.getControllerId()));
            return true;
        }
        return false;
    }
}

