/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class PrototypeEffect
extends ContinuousEffectImpl {
    private final int power;
    private final int toughness;
    private final String manaString;
    private final ObjectColor color;

    PrototypeEffect(int power, int toughness, String manaString) {
        super(Duration.EndOfGame, Layer.CopyEffects_1, SubLayer.CopyEffects_1a, Outcome.Benefit);
        this.power = power;
        this.toughness = toughness;
        this.manaString = manaString;
        this.color = new ObjectColor(manaString);
    }

    private PrototypeEffect(PrototypeEffect effect) {
        super(effect);
        this.power = effect.power;
        this.toughness = effect.toughness;
        this.manaString = effect.manaString;
        this.color = effect.color;
    }

    @Override
    public PrototypeEffect copy() {
        return new PrototypeEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (permanent == null || !permanent.isPrototyped()) {
            return false;
        }
        permanent.setManaCost(new ManaCostsImpl<ManaCost>(this.manaString));
        permanent.getColor(game).setColor(this.color);
        permanent.getPower().setModifiedBaseValue(this.power);
        permanent.getToughness().setModifiedBaseValue(this.toughness);
        return true;
    }
}

