/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.hint.common.RenownedHint;
import mage.abilities.keyword.BecomesRenownedSourceEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

public class RenownAbility
extends TriggeredAbilityImpl {
    private int renownValue;

    public RenownAbility(int renownValue) {
        super(Zone.BATTLEFIELD, new BecomesRenownedSourceEffect(renownValue), false);
        this.renownValue = renownValue;
        this.addHint(RenownedHint.instance);
    }

    private RenownAbility(RenownAbility ability) {
        super(ability);
        this.renownValue = ability.renownValue;
    }

    @Override
    public RenownAbility copy() {
        return new RenownAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    @Override
    public boolean checkInterveningIfClause(Game game) {
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(this.getSourceId());
        return sourcePermanent != null && !sourcePermanent.isRenowned();
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        return event.getSourceId().equals(this.getSourceId()) && ((DamagedPlayerEvent)event).isCombatDamage();
    }

    public int getRenownValue() {
        return this.renownValue;
    }
}

