/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.common.DiesSourceTriggeredAbility;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.abilities.effects.common.counter.RemoveCounterSourceEffect;
import mage.abilities.keyword.RepairCastFromGraveyardTriggeredAbility;
import mage.abilities.triggers.BeginningOfUpkeepTriggeredAbility;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.counters.CounterType;

public class RepairAbility
extends DiesSourceTriggeredAbility {
    private final int count;

    public RepairAbility(int count) {
        super(new AddCountersSourceEffect(CounterType.REPAIR.createInstance(), StaticValue.get(count), false, true));
        this.addSubAbility(new BeginningOfUpkeepTriggeredAbility(Zone.GRAVEYARD, TargetController.YOU, new RemoveCounterSourceEffect(CounterType.REPAIR.createInstance()), false).setRuleVisible(false));
        this.addSubAbility(new RepairCastFromGraveyardTriggeredAbility());
        this.count = count;
    }

    protected RepairAbility(RepairAbility ability) {
        super(ability);
        this.count = ability.count;
    }

    @Override
    public String getRule() {
        return "Repair " + this.count + " <i>(When this creature dies, put " + this.count + " repair counters on it. At the beginning of your upkeep, remove a repair counter. Whenever the last is removed, you may cast it from graveyard until end of turn.)</i>";
    }

    @Override
    public RepairAbility copy() {
        return new RepairAbility(this);
    }
}

