/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.awt.Color;
import java.util.Objects;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.CrewSaddleIncreasedPowerAbility;
import mage.abilities.common.CrewSaddleWithToughnessAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.abilities.hint.HintUtils;
import mage.constants.Outcome;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.TargetPermanent;

class SaddleCost
extends CostImpl {
    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("another untapped creature you control");
    private final int value;

    SaddleCost(int value) {
        this.value = value;
    }

    private SaddleCost(SaddleCost cost) {
        super(cost);
        this.value = cost.value;
    }

    @Override
    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        TargetPermanent target = new TargetPermanent(0, Integer.MAX_VALUE, filter, true){

            @Override
            public String getMessage(Game game) {
                int selectedPower = this.targets.keySet().stream().map(game::getPermanent).filter(Objects::nonNull).mapToInt(p -> SaddleCost.getSaddlePower(p, game)).sum();
                String extraInfo = "(selected power " + selectedPower + " of " + SaddleCost.this.value + ")";
                if (selectedPower >= SaddleCost.this.value) {
                    extraInfo = HintUtils.prepareText(extraInfo, Color.GREEN);
                }
                return super.getMessage(game) + " " + extraInfo;
            }
        };
        if (target.choose(Outcome.Tap, controllerId, source.getSourceId(), source, game)) {
            int sumPower = 0;
            for (UUID targetId : target.getTargets()) {
                Permanent permanent;
                GameEvent event = new GameEvent(GameEvent.EventType.SADDLE_MOUNT, targetId, source, controllerId);
                if (game.replaceEvent(event) || (permanent = game.getPermanent(targetId)) == null || !permanent.tap(source, game)) continue;
                sumPower += SaddleCost.getSaddlePower(permanent, game);
            }
            boolean bl = this.paid = sumPower >= this.value;
            if (this.paid) {
                for (UUID targetId : target.getTargets()) {
                    game.fireEvent(GameEvent.getEvent(GameEvent.EventType.SADDLED_MOUNT, targetId, source, controllerId));
                }
            }
        } else {
            return false;
        }
        return this.paid;
    }

    @Override
    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        int sumPower = 0;
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents(filter, controllerId, game)) {
            if ((sumPower += Math.max(SaddleCost.getSaddlePower(permanent, game), 0)) < this.value) continue;
            return true;
        }
        return false;
    }

    @Override
    public SaddleCost copy() {
        return new SaddleCost(this);
    }

    private static int getSaddlePower(Permanent permanent, Game game) {
        if (permanent.hasAbility(CrewSaddleWithToughnessAbility.getInstance(), game)) {
            return permanent.getToughness().getValue();
        }
        if (permanent.getAbilities(game).containsClass(CrewSaddleIncreasedPowerAbility.class)) {
            return permanent.getPower().getValue() + 2;
        }
        return permanent.getPower().getValue();
    }

    static {
        filter.add(TappedPredicate.UNTAPPED);
        filter.add(AnotherPredicate.instance);
    }
}

