/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;

class ScavengeEffect
extends OneShotEffect {
    ScavengeEffect() {
        super(Outcome.BoostCreature);
    }

    ScavengeEffect(ScavengeEffect effect) {
        super(effect);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        int count;
        Card card = game.getCard(source.getSourceId());
        if (card != null && (count = card.getPower().getValue()) > 0) {
            AddCountersTargetEffect effect = new AddCountersTargetEffect(CounterType.P1P1.createInstance(count));
            effect.setTargetPointer(this.getTargetPointer().copy());
            return effect.apply(game, source);
        }
        return false;
    }

    @Override
    public ScavengeEffect copy() {
        return new ScavengeEffect(this);
    }
}

