/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.Costs;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.keyword.SpliceCardEffectImpl;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterObject;
import mage.filter.predicate.Predicates;

public class SpliceAbility
extends SimpleStaticAbility {
    public static final FilterObject ARCANE = new FilterObject("Arcane");
    public static final FilterObject INSTANT_OR_SORCERY = new FilterObject("instant or sorcery");
    private final Costs<Cost> spliceCosts = new CostsImpl<Cost>();
    private final String rule;

    public SpliceAbility(FilterObject filter, String manaString) {
        super(Zone.HAND, new SpliceCardEffectImpl(filter));
        this.spliceCosts.add(new ManaCostsImpl(manaString));
        this.rule = "Splice onto " + filter.getMessage() + ' ' + this.spliceCosts.getText() + SpliceAbility.getReminder(filter);
    }

    public SpliceAbility(FilterObject filter, Cost cost) {
        super(Zone.HAND, new SpliceCardEffectImpl(filter));
        this.spliceCosts.add(cost);
        this.rule = "Splice onto " + filter.getMessage() + "&mdash;" + this.spliceCosts.getText() + '.' + SpliceAbility.getReminder(filter);
    }

    private SpliceAbility(SpliceAbility ability) {
        super(ability);
        this.spliceCosts.addAll(ability.spliceCosts);
        this.rule = ability.rule;
    }

    @Override
    public SpliceAbility copy() {
        return new SpliceAbility(this);
    }

    public Costs getSpliceCosts() {
        return this.spliceCosts;
    }

    private static String getReminder(FilterObject filter) {
        return " <i>(As you cast an " + filter.getMessage() + " spell, you may reveal this card from your hand and pay its splice cost. If you do, add this card's effects to that spell.)</i>";
    }

    @Override
    public String getRule() {
        return this.rule;
    }

    static {
        ARCANE.add(SubType.ARCANE.getPredicate());
        ARCANE.setLockedFilter(true);
        INSTANT_OR_SORCERY.add(Predicates.or(CardType.INSTANT.getPredicate(), CardType.SORCERY.getPredicate()));
        INSTANT_OR_SORCERY.setLockedFilter(true);
    }
}

