/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.StaticAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.Costs;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.OptionalAdditionalCost;
import mage.abilities.costs.OptionalAdditionalCostImpl;
import mage.abilities.costs.OptionalAdditionalSourceCosts;
import mage.abilities.costs.VariableCostType;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.keyword.SquadTriggerAbility;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

public class SquadAbility
extends StaticAbility
implements OptionalAdditionalSourceCosts {
    protected OptionalAdditionalCost cost;
    protected static final String SQUAD_KEYWORD = "Squad";
    protected static final String SQUAD_ACTIVATION_VALUE_KEY = "squadActivationCount";
    protected static final String SQUAD_REMINDER = "You may pay an additional {cost} any number of times as you cast this spell.";

    private static Costs<Cost> wrapSingleCost(Cost cost) {
        CostsImpl<Cost> costs = new CostsImpl<Cost>();
        costs.add(cost);
        return costs;
    }

    public SquadAbility(Cost cost) {
        this(SquadAbility.wrapSingleCost(cost));
    }

    public SquadAbility(Costs<Cost> cost) {
        super(Zone.STACK, null);
        this.setSquadCost(cost);
        this.addSubAbility(new SquadTriggerAbility());
    }

    private SquadAbility(SquadAbility ability) {
        super(ability);
        this.cost = ability.cost.copy();
    }

    @Override
    public void addCost(Cost cost) {
        throw new IllegalArgumentException("Wrong code usage: costs for Squad should be set all at once.");
    }

    @Override
    public SquadAbility copy() {
        return new SquadAbility(this);
    }

    private void setSquadCost(Costs<Cost> costs) {
        OptionalAdditionalCostImpl newCost = new OptionalAdditionalCostImpl(SQUAD_KEYWORD, SQUAD_REMINDER, costs);
        newCost.setRepeatable(true);
        newCost.setCostType(VariableCostType.ADDITIONAL);
        this.cost = newCost;
    }

    private void reset() {
        this.cost.reset();
    }

    @Override
    public void addOptionalAdditionalCosts(Ability ability, Game game) {
        if (!(ability instanceof SpellAbility)) {
            return;
        }
        Player player = game.getPlayer(ability.getControllerId());
        if (player == null) {
            return;
        }
        this.reset();
        boolean again = true;
        while (player.canRespond() && again) {
            String times = "";
            int activatedCount = this.cost.getActivateCount();
            times = activatedCount + 1 + (activatedCount == 0 ? " time " : " times ");
            if (this.cost.canPay(ability, this, ability.getControllerId(), game) && player.chooseUse(Outcome.AIDontUseIt, "Pay " + times + this.cost.getText(false) + " ?", ability, game)) {
                this.cost.activate();
                if (this.cost instanceof ManaCostsImpl) {
                    ability.getManaCostsToPay().add((ManaCostsImpl)((Object)this.cost.copy()));
                    continue;
                }
                ability.getCosts().add(this.cost.copy());
                continue;
            }
            again = false;
        }
        ability.setCostsTag(SQUAD_ACTIVATION_VALUE_KEY, this.cost.getActivateCount());
    }

    @Override
    public String getCastMessageSuffix() {
        if (this.cost.isActivated()) {
            return this.cost.getCastSuffixMessage(0);
        }
        return "";
    }

    @Override
    public String getRule() {
        return "Squad " + this.cost.getText() + " <i>(As an additional cost to cast this spell, you may pay " + this.cost.getText() + "any number of times. When this creature enters, create that many tokens that are copies of it.)</i>";
    }
}

