/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.StaticAbility;
import mage.abilities.keyword.StationLevelAbilityEffect;
import mage.abilities.keyword.StationLevelCreatureEffect;
import mage.constants.Zone;
import mage.util.CardUtil;

public class StationLevelAbility
extends StaticAbility {
    private final int level;

    public StationLevelAbility(int level) {
        super(Zone.BATTLEFIELD, null);
        this.level = level;
    }

    private StationLevelAbility(StationLevelAbility ability) {
        super(ability);
        this.level = ability.level;
    }

    @Override
    public StationLevelAbility copy() {
        return new StationLevelAbility(this);
    }

    public StationLevelAbility withLevelAbility(Ability ability) {
        this.addEffect(new StationLevelAbilityEffect(ability, this.level));
        return this;
    }

    public StationLevelAbility withPT(int power, int toughness) {
        this.addEffect(new StationLevelCreatureEffect(power, toughness, this.level));
        return this;
    }

    @Override
    public String getRule() {
        return "STATION " + this.level + "+<br>" + this.getEffects().stream().map(effect -> effect.getText(this.getModes().getMode())).map(CardUtil::getTextWithFirstCharUpperCase).collect(Collectors.joining("<br>"));
    }

    public boolean hasPT() {
        return this.getEffects().stream().anyMatch(StationLevelCreatureEffect.class::isInstance);
    }
}

