/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.ArrayList;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.SunburstCount;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class SunburstEffect
extends OneShotEffect {
    private static final DynamicValue amount = SunburstCount.instance;

    public SunburstEffect() {
        super(Outcome.Benefit);
        this.staticText = "Sunburst";
    }

    protected SunburstEffect(SunburstEffect effect) {
        super(effect);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        int countersAmount;
        Permanent permanent = game.getPermanentEntering(source.getSourceId());
        if (permanent != null && (countersAmount = amount.calculate(game, source, this)) > 0) {
            Player player;
            Counter counter = permanent.isCreature(game) ? CounterType.P1P1.createInstance(countersAmount) : CounterType.CHARGE.createInstance(countersAmount);
            ArrayList appliedEffects = (ArrayList)this.getValue("appliedEffects");
            permanent.addCounters(counter, source.getControllerId(), source, game, appliedEffects);
            if (!game.isSimulation() && (player = game.getPlayer(source.getControllerId())) != null) {
                game.informPlayers(player.getLogName() + " puts " + counter.getCount() + ' ' + counter.getName() + " counter on " + permanent.getName());
            }
        }
        return true;
    }

    @Override
    public SunburstEffect copy() {
        return new SunburstEffect(this);
    }
}

