/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.Set;
import java.util.UUID;
import mage.ApprovingObject;
import mage.MageIdentifier;
import mage.abilities.ActivatedAbility;
import mage.abilities.SpellAbility;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.cards.Card;
import mage.constants.SpellAbilityType;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.watchers.common.CastSpellLastTurnWatcher;

public class SurgeAbility
extends SpellAbility {
    public static final String SURGE_ACTIVATION_VALUE_KEY = "surgeActivation";
    private final String rule;

    public SurgeAbility(Card card, String surgeCosts) {
        super(card.getSpellAbility());
        this.newId();
        this.setCardName(card.getName() + " with surge");
        this.zone = Zone.HAND;
        this.spellAbilityType = SpellAbilityType.BASE_ALTERNATE;
        this.clearManaCosts();
        this.clearManaCostsToPay();
        this.addCost(new ManaCostsImpl(surgeCosts));
        this.setRuleAtTheTop(true);
        this.rule = "Surge " + surgeCosts + " <i>(You may cast this spell for its surge cost if you or a teammate has cast another spell this turn.)</i>";
    }

    protected SurgeAbility(SurgeAbility ability) {
        super(ability);
        this.rule = ability.rule;
    }

    @Override
    public ActivatedAbility.ActivationStatus canActivate(UUID playerId, Game game) {
        Player player;
        CastSpellLastTurnWatcher watcher = game.getState().getWatcher(CastSpellLastTurnWatcher.class);
        if (watcher != null && (player = game.getPlayer(playerId)) != null) {
            for (UUID playerToCheckId : game.getState().getPlayersInRange(playerId, game)) {
                if (player.hasOpponent(playerToCheckId, game) || watcher.getAmountOfSpellsPlayerCastOnCurrentTurn(playerToCheckId) <= 0 || !super.canActivate(playerId, game).canActivate()) continue;
                return new ActivatedAbility.ActivationStatus(new ApprovingObject(this, game));
            }
        }
        return ActivatedAbility.ActivationStatus.getFalse();
    }

    @Override
    public boolean activate(Game game, Set<MageIdentifier> allowedIdentifiers, boolean noMana) {
        if (super.activate(game, allowedIdentifiers, noMana)) {
            this.setCostsTag(SURGE_ACTIVATION_VALUE_KEY, null);
            return true;
        }
        return false;
    }

    @Override
    public SurgeAbility copy() {
        return new SurgeAbility(this);
    }

    @Override
    public String getRule(boolean all) {
        return this.getRule();
    }

    @Override
    public String getRule() {
        return this.rule;
    }
}

