/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetOpponent;
import mage.util.CardUtil;

class TributeEffect
extends OneShotEffect {
    private final int tributeValue;

    public TributeEffect(int tributeValue) {
        super(Outcome.Detriment);
        this.tributeValue = tributeValue;
    }

    protected TributeEffect(TributeEffect effect) {
        super(effect);
        this.tributeValue = effect.tributeValue;
    }

    @Override
    public TributeEffect copy() {
        return new TributeEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanentEntering(source.getSourceId());
        if (controller != null && sourcePermanent != null) {
            Player opponent;
            UUID opponentId;
            if (game.getOpponents(controller.getId()).size() == 1) {
                opponentId = game.getOpponents(controller.getId()).iterator().next();
            } else {
                TargetOpponent target = new TargetOpponent();
                controller.choose(this.outcome, target, source, game);
                opponentId = target.getFirstTarget();
            }
            if (opponentId != null && (opponent = game.getPlayer(opponentId)) != null) {
                StringBuilder sb = new StringBuilder("Pay tribute to ");
                sb.append(sourcePermanent.getName());
                sb.append(" (add ").append(CardUtil.numberToText(this.tributeValue)).append(" +1/+1 counter");
                sb.append(this.tributeValue > 1 ? "s" : "").append(" to it)?");
                if (opponent.chooseUse(this.outcome, sb.toString(), source, game)) {
                    if (!game.isSimulation()) {
                        game.informPlayers(opponent.getLogName() + " pays tribute to " + sourcePermanent.getLogName());
                    }
                    game.getState().setValue("tributeValue" + source.getSourceId(), "yes");
                    return sourcePermanent.addCounters(CounterType.P1P1.createInstance(this.tributeValue), opponent.getId(), source, game);
                }
                if (!game.isSimulation()) {
                    game.informPlayers(opponent.getLogName() + " does not pay tribute to " + sourcePermanent.getLogName());
                }
                game.getState().setValue("tributeValue" + source.getSourceId(), "no");
                return true;
            }
        }
        return false;
    }
}

