/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class UnleashRestrictionEffect
extends RestrictionEffect {
    public UnleashRestrictionEffect() {
        super(Duration.WhileOnBattlefield);
    }

    protected UnleashRestrictionEffect(UnleashRestrictionEffect effect) {
        super(effect);
    }

    @Override
    public boolean applies(Permanent permanent, Ability source, Game game) {
        if (permanent != null && permanent.getId().equals(source.getSourceId())) {
            return permanent.getCounters(game).getCount(CounterType.P1P1) > 0;
        }
        return false;
    }

    @Override
    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return false;
    }

    @Override
    public UnleashRestrictionEffect copy() {
        return new UnleashRestrictionEffect(this);
    }
}

