/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.keyword;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.WarpAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.util.CardUtil;

class WarpExileEffect
extends OneShotEffect {
    WarpExileEffect(Permanent permanent, Game game) {
        super(Outcome.Benefit);
        this.setTargetPointer(new FixedTarget(permanent, game));
        this.staticText = "exile this creature if it was cast for its warp cost";
    }

    private WarpExileEffect(WarpExileEffect effect) {
        super(effect);
    }

    @Override
    public WarpExileEffect copy() {
        return new WarpExileEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        Player player = game.getPlayer(permanent.getOwnerId());
        if (player == null) {
            return false;
        }
        player.moveCardsToExile(permanent, source, game, true, CardUtil.getExileZoneId(WarpAbility.makeWarpString(player.getId()), game), "Warped by " + player.getName());
        CardUtil.makeCardPlayable(game, source, permanent.getMainCard(), true, Duration.Custom, false, player.getId(), new WarpCondition(game));
        return true;
    }

    private static class WarpCondition
    implements Condition {
        private final int turnNumber;

        WarpCondition(Game game) {
            this.turnNumber = game.getTurnNum();
        }

        @Override
        public boolean apply(Game game, Ability source) {
            return game.getTurnNum() > this.turnNumber;
        }
    }
}

