/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.mana;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mage.Mana;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.mana.ManaEffect;
import mage.cards.Card;
import mage.choices.Choice;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;

class AnyColorCardInYourGraveyardManaEffect
extends ManaEffect {
    private final FilterCard filter;
    private transient boolean inManaTypeCalculation = false;

    public AnyColorCardInYourGraveyardManaEffect(FilterCard cardFilter) {
        this.filter = cardFilter;
        this.staticText = "Add one mana of any color among " + cardFilter.getMessage() + " in your graveyard.";
    }

    protected AnyColorCardInYourGraveyardManaEffect(AnyColorCardInYourGraveyardManaEffect effect) {
        super(effect);
        this.filter = effect.filter.copy();
    }

    @Override
    public List<Mana> getNetMana(Game game, Ability source) {
        return game == null ? new ArrayList<Mana>() : ManaType.getManaListFromManaTypes(this.getManaTypes(game, source), true);
    }

    @Override
    public Mana produceMana(Game game, Ability source) {
        if (game == null) {
            return null;
        }
        Set<ManaType> types = this.getManaTypes(game, source);
        if (types.isEmpty()) {
            return null;
        }
        Choice choice = ManaType.getChoiceOfManaTypes(types, true);
        if (choice.getChoices().size() == 1) {
            choice.setChoice(choice.getChoices().iterator().next());
        } else {
            Player player = game.getPlayer(source.getControllerId());
            if (player == null || !player.choose(Outcome.PutManaInPool, choice, game)) {
                return null;
            }
        }
        ManaType chosenType = ManaType.findByName(choice.getChoice());
        return chosenType == null ? null : new Mana(chosenType);
    }

    private Set<ManaType> getManaTypes(Game game, Ability source) {
        HashSet<ManaType> manaTypes = new HashSet<ManaType>(6);
        if (game == null || game.getPhase() == null || this.inManaTypeCalculation) {
            return manaTypes;
        }
        this.inManaTypeCalculation = true;
        Set<Card> cards = game.getPlayer(source.getControllerId()).getGraveyard().getCards(this.filter, game);
        for (Card card : cards) {
            ObjectColor cardColor = card.getColor(game);
            if (cardColor.isBlack()) {
                manaTypes.add(ManaType.BLACK);
            }
            if (cardColor.isBlue()) {
                manaTypes.add(ManaType.BLUE);
            }
            if (cardColor.isGreen()) {
                manaTypes.add(ManaType.GREEN);
            }
            if (cardColor.isRed()) {
                manaTypes.add(ManaType.RED);
            }
            if (cardColor.isWhite()) {
                manaTypes.add(ManaType.WHITE);
            }
            if (manaTypes.size() != 5) continue;
            break;
        }
        this.inManaTypeCalculation = false;
        return manaTypes;
    }

    @Override
    public AnyColorCardInYourGraveyardManaEffect copy() {
        return new AnyColorCardInYourGraveyardManaEffect(this);
    }
}

