/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.mana;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.mana.ManaEffect;
import mage.abilities.mana.AnyColorLandsProduceManaAbility;
import mage.choices.Choice;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AnyColorLandsProduceManaEffect
extends ManaEffect {
    private final FilterPermanent filter;
    private final boolean onlyColors;
    private transient boolean inManaTypeCalculation = false;

    AnyColorLandsProduceManaEffect(TargetController targetController, boolean onlyColors, FilterPermanent filter) {
        this.filter = filter == null ? new FilterLandPermanent() : filter.copy();
        this.onlyColors = onlyColors;
        this.filter.add(targetController.getControllerPredicate());
        String text = targetController == TargetController.OPPONENT ? "an opponent controls" : "you control";
        this.staticText = "Add one mana of any " + (this.onlyColors ? "color" : "type") + " that a " + (filter == null ? "land " : filter.getMessage() + " ") + text + " could produce";
    }

    private AnyColorLandsProduceManaEffect(AnyColorLandsProduceManaEffect effect) {
        super(effect);
        this.filter = effect.filter.copy();
        this.onlyColors = effect.onlyColors;
    }

    @Override
    public List<Mana> getNetMana(Game game, Ability source) {
        return game == null ? new ArrayList<Mana>() : ManaType.getManaListFromManaTypes(this.getManaTypes(game, source), this.onlyColors);
    }

    @Override
    public Mana produceMana(Game game, Ability source) {
        if (game == null) {
            return null;
        }
        Set<ManaType> types = this.getManaTypes(game, source);
        if (types.isEmpty()) {
            return null;
        }
        Choice choice = ManaType.getChoiceOfManaTypes(types, this.onlyColors);
        if (choice.getChoices().size() == 1) {
            choice.setChoice(choice.getChoices().iterator().next());
        } else {
            Player player = game.getPlayer(source.getControllerId());
            if (player == null || !player.choose(Outcome.PutManaInPool, choice, game)) {
                return null;
            }
        }
        ManaType chosenType = ManaType.findByName(choice.getChoice());
        return chosenType == null ? null : new Mana(chosenType);
    }

    private Set<ManaType> getManaTypes(Game game, Ability source) {
        HashSet<ManaType> types = new HashSet<ManaType>(6);
        if (game == null || game.getPhase() == null) {
            return types;
        }
        if (this.inManaTypeCalculation) {
            return types;
        }
        this.inManaTypeCalculation = true;
        List<Permanent> lands = game.getBattlefield().getActivePermanents(this.filter, source.getControllerId(), source, game);
        for (Permanent land : lands) {
            if (land.getId().equals(source.getSourceId())) continue;
            types.addAll(AnyColorLandsProduceManaAbility.getManaTypesFromPermanent(land, game));
        }
        this.inManaTypeCalculation = false;
        if (this.onlyColors) {
            types.remove((Object)ManaType.COLORLESS);
        }
        return types;
    }

    @Override
    public AnyColorLandsProduceManaEffect copy() {
        return new AnyColorLandsProduceManaEffect(this);
    }
}

