/*
 * Decompiled with CFR 0.152.
 */
package mage.abilities.meta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.hint.Hint;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;
import mage.watchers.Watcher;

public class OrTriggeredAbility
extends TriggeredAbilityImpl {
    private final String ruleTrigger;
    private final List<TriggeredAbility> triggeredAbilities = new ArrayList<TriggeredAbility>();

    public OrTriggeredAbility(Zone zone, Effect effect, TriggeredAbility ... abilities) {
        this(zone, effect, false, null, abilities);
    }

    public OrTriggeredAbility(Zone zone, Effect effect, boolean optional, String ruleTrigger, TriggeredAbility ... abilities) {
        super(zone, effect, optional);
        this.ruleTrigger = ruleTrigger;
        this.withRuleTextReplacement(false);
        Collections.addAll(this.triggeredAbilities, abilities);
        for (TriggeredAbility ability : this.triggeredAbilities) {
            ability.getEffects().clear();
            for (Watcher watcher : ability.getWatchers()) {
                super.addWatcher(watcher);
            }
            if (!ability.isLeavesTheBattlefieldTrigger()) continue;
            this.setLeavesTheBattlefieldTrigger(true);
        }
        this.setTriggerPhrase(this.generateTriggerPhrase());
        boolean haveEnters = false;
        boolean haveSacrifice = false;
        for (TriggeredAbility ability : abilities) {
            if (ability.getRule().toLowerCase(Locale.ENGLISH).contains("enters")) {
                haveEnters = true;
            }
            if (!ability.getRule().toLowerCase(Locale.ENGLISH).contains("sacrifice")) continue;
            haveSacrifice = true;
        }
        if (zone != Zone.ALL && haveEnters && haveSacrifice) {
            throw new IllegalArgumentException("Wrong code usage: on enters and sacrifice OrTriggeredAbility must use Zone.ALL");
        }
    }

    public OrTriggeredAbility(OrTriggeredAbility ability) {
        super(ability);
        this.ruleTrigger = ability.ruleTrigger;
        for (TriggeredAbility triggeredAbility : ability.triggeredAbilities) {
            this.triggeredAbilities.add(triggeredAbility.copy());
        }
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        for (TriggeredAbility ability : this.triggeredAbilities) {
            if (!ability.checkEventType(event, game)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        boolean toRet = false;
        for (TriggeredAbility ability : this.triggeredAbilities) {
            for (Effect e : this.getEffects()) {
                ability.addEffect(e);
            }
            ability.getTargets().addAll(this.getTargets());
            if (ability.checkEventType(event, game) && ability.checkTrigger(event, game) && ability.checkTriggerCondition(game)) {
                toRet = true;
            }
            ability.getTargets().clear();
            ability.getEffects().clear();
        }
        return toRet;
    }

    @Override
    public OrTriggeredAbility copy() {
        return new OrTriggeredAbility(this);
    }

    private String generateTriggerPhrase() {
        if (this.ruleTrigger != null && !this.ruleTrigger.isEmpty()) {
            return this.ruleTrigger;
        }
        return this.triggeredAbilities.stream().map(Ability::getRule).map(CardUtil::getTextWithFirstCharLowerCase).map(s -> s.substring(0, s.length() - 2)).collect(Collectors.joining(" or ")) + ", ";
    }

    @Override
    public void setControllerId(UUID controllerId) {
        super.setControllerId(controllerId);
        for (TriggeredAbility ability : this.triggeredAbilities) {
            ability.setControllerId(controllerId);
        }
    }

    @Override
    public void setSourceId(UUID sourceId) {
        super.setSourceId(sourceId);
        for (TriggeredAbility ability : this.triggeredAbilities) {
            ability.setSourceId(sourceId);
        }
    }

    @Override
    public void addWatcher(Watcher watcher) {
        super.addWatcher(watcher);
        for (TriggeredAbility ability : this.triggeredAbilities) {
            ability.addWatcher(watcher);
        }
    }

    @Override
    public List<Hint> getHints() {
        ArrayList<Hint> res = new ArrayList<Hint>(super.getHints());
        this.triggeredAbilities.forEach(a -> res.addAll(a.getHints()));
        return res;
    }

    @Override
    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        boolean res = false;
        for (TriggeredAbility ability : this.triggeredAbilities) {
            if (ability.isLeavesTheBattlefieldTrigger()) {
                res |= TriggeredAbilityImpl.isInUseableZoneDiesTrigger(this, sourceObject, event, game);
                continue;
            }
            res |= super.isInUseableZone(game, sourceObject, event);
        }
        return res;
    }
}

