/*
 * Decompiled with CFR 0.152.
 */
package mage.cards;

import java.util.Arrays;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.ActivatedAbility;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.ExileAdventureSpellEffect;
import mage.cards.AdventureCard;
import mage.cards.AdventureSpellCard;
import mage.cards.Card;
import mage.constants.CardType;
import mage.game.ExileZone;
import mage.game.Game;
import mage.util.CardUtil;

class AdventureCardSpellAbility
extends SpellAbility {
    private String nameFull;
    private boolean finalized = false;

    public AdventureCardSpellAbility(SpellAbility baseSpellAbility, String adventureName, CardType[] cardTypes, String costs) {
        super(baseSpellAbility);
        this.setName(cardTypes, adventureName, costs);
        this.setCardName(adventureName);
    }

    public void finalizeAdventure() {
        if (this.finalized) {
            throw new IllegalStateException("Wrong code usage. Adventure (" + this.cardName + ") need to call finalizeAdventure() exactly once.");
        }
        this.addEffect(ExileAdventureSpellEffect.getInstance());
        this.finalized = true;
    }

    protected AdventureCardSpellAbility(AdventureCardSpellAbility ability) {
        super(ability);
        this.nameFull = ability.nameFull;
        if (!ability.finalized) {
            throw new IllegalStateException("Wrong code usage. Adventure (" + this.cardName + ") need to call finalizeAdventure() at the very end of the card's constructor.");
        }
        this.finalized = true;
    }

    @Override
    public ActivatedAbility.ActivationStatus canActivate(UUID playerId, Game game) {
        ExileZone adventureExileZone = game.getExile().getExileZone(ExileAdventureSpellEffect.adventureExileId(playerId, game));
        Card spellCard = game.getCard(this.getSourceId());
        if (spellCard instanceof AdventureSpellCard) {
            AdventureCard card = ((AdventureSpellCard)spellCard).getParentCard();
            if (adventureExileZone != null && adventureExileZone.contains(card.getId())) {
                return ActivatedAbility.ActivationStatus.getFalse();
            }
        }
        return super.canActivate(playerId, game);
    }

    public void setName(CardType[] cardTypes, String name, String costs) {
        this.nameFull = "Adventure " + Arrays.stream(cardTypes).map(CardType::toString).collect(Collectors.joining(" ")) + " &mdash; " + name;
        this.name = this.nameFull + " " + costs;
    }

    @Override
    public String getRule(boolean all) {
        return this.nameFull + " " + this.getManaCosts().getText() + " &mdash; " + CardUtil.getTextWithFirstCharUpperCase(super.getRule(false)) + " <i>(Then exile this card. You may cast the creature later from exile.)</i>";
    }

    @Override
    public AdventureCardSpellAbility copy() {
        return new AdventureCardSpellAbility(this);
    }
}

