/*
 * Decompiled with CFR 0.152.
 */
package mage.cards;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.cards.AdventureCard;
import mage.cards.AdventureCardSpellAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.CardWithSpellOption;
import mage.cards.SpellOptionCard;
import mage.constants.CardType;
import mage.constants.SpellAbilityType;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;

public class AdventureSpellCard
extends CardImpl
implements SpellOptionCard {
    private AdventureCard adventureCardParent;

    public AdventureSpellCard(UUID ownerId, CardSetInfo setInfo, String adventureName, CardType[] cardTypes, String costs, AdventureCard adventureCardParent) {
        super(ownerId, setInfo, cardTypes, costs, SpellAbilityType.ADVENTURE_SPELL);
        this.subtype.add(SubType.ADVENTURE);
        AdventureCardSpellAbility newSpellAbility = new AdventureCardSpellAbility(this.getSpellAbility(), adventureName, cardTypes, costs);
        this.replaceSpellAbility(newSpellAbility);
        this.spellAbility = newSpellAbility;
        this.setName(adventureName);
        this.adventureCardParent = adventureCardParent;
    }

    @Override
    public void finalizeSpell() {
        if (this.spellAbility instanceof AdventureCardSpellAbility) {
            ((AdventureCardSpellAbility)this.spellAbility).finalizeAdventure();
        }
    }

    protected AdventureSpellCard(AdventureSpellCard card) {
        super(card);
        this.adventureCardParent = card.adventureCardParent;
    }

    @Override
    public UUID getOwnerId() {
        return this.adventureCardParent.getOwnerId();
    }

    @Override
    public String getExpansionSetCode() {
        return this.adventureCardParent.getExpansionSetCode();
    }

    @Override
    public String getCardNumber() {
        return this.adventureCardParent.getCardNumber();
    }

    @Override
    public boolean moveToZone(Zone toZone, Ability source, Game game, boolean flag, List<UUID> appliedEffects) {
        return this.adventureCardParent.moveToZone(toZone, source, game, flag, appliedEffects);
    }

    @Override
    public boolean moveToExile(UUID exileId, String name, Ability source, Game game, List<UUID> appliedEffects) {
        return this.adventureCardParent.moveToExile(exileId, name, source, game, appliedEffects);
    }

    @Override
    public AdventureCard getMainCard() {
        return this.adventureCardParent;
    }

    @Override
    public void setZone(Zone zone, Game game) {
        game.setZone(this.adventureCardParent.getId(), zone);
        game.setZone(this.adventureCardParent.getSpellCard().getId(), zone);
    }

    @Override
    public AdventureSpellCard copy() {
        return new AdventureSpellCard(this);
    }

    @Override
    public void setParentCard(CardWithSpellOption card) {
        this.adventureCardParent = (AdventureCard)card;
    }

    @Override
    public AdventureCard getParentCard() {
        return this.adventureCardParent;
    }

    @Override
    public String getIdName() {
        return this.getName() + " [" + this.adventureCardParent.getId().toString().substring(0, 3) + ']';
    }

    @Override
    public String getSpellType() {
        return "Adventure";
    }
}

