/*
 * Decompiled with CFR 0.152.
 */
package mage.cards;

import java.util.List;
import java.util.UUID;
import mage.abilities.Abilities;
import mage.abilities.AbilitiesImpl;
import mage.abilities.Ability;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.SpellOptionCard;
import mage.constants.CardType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.ZoneChangeEvent;
import mage.util.CardUtil;

public abstract class CardWithSpellOption
extends CardImpl {
    protected SpellOptionCard spellCard;

    public CardWithSpellOption(UUID ownerId, CardSetInfo setInfo, CardType[] types, String costs) {
        super(ownerId, setInfo, types, costs);
    }

    public CardWithSpellOption(CardWithSpellOption card) {
        super(card);
        this.spellCard = card.getSpellCard().copy();
        this.spellCard.setParentCard(this);
    }

    public SpellOptionCard getSpellCard() {
        return this.spellCard;
    }

    public void setParts(SpellOptionCard cardSpell) {
        this.spellCard = cardSpell;
        cardSpell.setParentCard(this);
    }

    @Override
    public void assignNewId() {
        super.assignNewId();
        this.spellCard.assignNewId();
    }

    @Override
    public boolean moveToZone(Zone toZone, Ability source, Game game, boolean flag, List<UUID> appliedEffects) {
        if (super.moveToZone(toZone, source, game, flag, appliedEffects)) {
            Zone currentZone = game.getState().getZone(this.getId());
            game.getState().setZone(this.getSpellCard().getId(), currentZone);
            return true;
        }
        return false;
    }

    @Override
    public void setZone(Zone zone, Game game) {
        super.setZone(zone, game);
        game.setZone(this.getSpellCard().getId(), zone);
    }

    @Override
    public boolean moveToExile(UUID exileId, String name, Ability source, Game game, List<UUID> appliedEffects) {
        if (super.moveToExile(exileId, name, source, game, appliedEffects)) {
            Zone currentZone = game.getState().getZone(this.getId());
            game.getState().setZone(this.getSpellCard().getId(), currentZone);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeFromZone(Game game, Zone fromZone, Ability source) {
        return super.removeFromZone(game, fromZone, source);
    }

    @Override
    public void updateZoneChangeCounter(Game game, ZoneChangeEvent event) {
        if (this.isCopy()) {
            super.updateZoneChangeCounter(game, event);
            return;
        }
        super.updateZoneChangeCounter(game, event);
        this.getSpellCard().updateZoneChangeCounter(game, event);
    }

    @Override
    public Abilities<Ability> getAbilities() {
        AbilitiesImpl<Ability> allAbilities = new AbilitiesImpl<Ability>();
        allAbilities.addAll(this.spellCard.getAbilities());
        allAbilities.addAll(super.getAbilities());
        return allAbilities;
    }

    @Override
    public Abilities<Ability> getInitAbilities() {
        return super.getAbilities();
    }

    @Override
    public Abilities<Ability> getAbilities(Game game) {
        AbilitiesImpl<Ability> allAbilities = new AbilitiesImpl<Ability>();
        allAbilities.addAll(this.spellCard.getAbilities(game));
        allAbilities.addAll(super.getAbilities(game));
        return allAbilities;
    }

    public Abilities<Ability> getSharedAbilities(Game game) {
        return super.getAbilities(game);
    }

    public List<String> getSharedRules(Game game) {
        Abilities<Ability> sourceAbilities = this.getSharedAbilities(game);
        return CardUtil.getCardRulesWithAdditionalInfo(game, this, sourceAbilities, sourceAbilities);
    }

    @Override
    public void setOwnerId(UUID ownerId) {
        super.setOwnerId(ownerId);
        this.abilities.setControllerId(ownerId);
        this.spellCard.getAbilities().setControllerId(ownerId);
        this.spellCard.setOwnerId(ownerId);
    }
}

