/*
 * Decompiled with CFR 0.152.
 */
package mage.cards;

import java.util.List;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Abilities;
import mage.abilities.AbilitiesImpl;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.cards.Card;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.CardWithHalves;
import mage.cards.SplitCardHalf;
import mage.cards.SplitCardHalfImpl;
import mage.constants.CardType;
import mage.constants.SpellAbilityType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.ZoneChangeEvent;
import mage.util.CardUtil;

public abstract class SplitCard
extends CardImpl
implements CardWithHalves {
    public static final String FUSE_RULE = "Fuse <i>(You may cast one or both halves of this card from your hand.)</i>";
    protected Card leftHalfCard;
    protected Card rightHalfCard;

    protected SplitCard(UUID ownerId, CardSetInfo setInfo, CardType[] cardTypes, String costsLeft, String costsRight, SpellAbilityType spellAbilityType) {
        this(ownerId, setInfo, cardTypes, cardTypes, costsLeft, costsRight, spellAbilityType);
    }

    protected SplitCard(UUID ownerId, CardSetInfo setInfo, CardType[] typesLeft, CardType[] typesRight, String costsLeft, String costsRight, SpellAbilityType spellAbilityType) {
        super(ownerId, setInfo, CardType.mergeTypes(typesLeft, typesRight), costsLeft + costsRight, spellAbilityType);
        String[] names = setInfo.getName().split(" // ");
        this.leftHalfCard = new SplitCardHalfImpl(this.getOwnerId(), new CardSetInfo(names[0], setInfo.getExpansionSetCode(), setInfo.getCardNumber(), setInfo.getRarity(), setInfo.getGraphicInfo()), typesLeft, costsLeft, this, SpellAbilityType.SPLIT_LEFT);
        this.rightHalfCard = new SplitCardHalfImpl(this.getOwnerId(), new CardSetInfo(names[1], setInfo.getExpansionSetCode(), setInfo.getCardNumber(), setInfo.getRarity(), setInfo.getGraphicInfo()), typesRight, costsRight, this, SpellAbilityType.SPLIT_RIGHT);
    }

    protected SplitCard(SplitCard card) {
        super(card);
        this.leftHalfCard = card.getLeftHalfCard().copy();
        ((SplitCardHalf)this.leftHalfCard).setParentCard(this);
        this.rightHalfCard = card.rightHalfCard.copy();
        ((SplitCardHalf)this.rightHalfCard).setParentCard(this);
    }

    public void setParts(SplitCardHalf leftHalfCard, SplitCardHalf rightHalfCard) {
        this.leftHalfCard = leftHalfCard;
        leftHalfCard.setParentCard(this);
        this.rightHalfCard = rightHalfCard;
        rightHalfCard.setParentCard(this);
    }

    @Override
    public SplitCardHalf getLeftHalfCard() {
        return (SplitCardHalf)this.leftHalfCard;
    }

    @Override
    public SplitCardHalf getRightHalfCard() {
        return (SplitCardHalf)this.rightHalfCard;
    }

    @Override
    public void assignNewId() {
        super.assignNewId();
        this.leftHalfCard.assignNewId();
        this.rightHalfCard.assignNewId();
    }

    @Override
    public void setCopy(boolean isCopy, MageObject copiedFrom) {
        super.setCopy(isCopy, copiedFrom);
        this.leftHalfCard.setCopy(isCopy, copiedFrom);
        this.rightHalfCard.setCopy(isCopy, copiedFrom);
    }

    @Override
    public boolean moveToZone(Zone toZone, Ability source, Game game, boolean flag, List<UUID> appliedEffects) {
        if (super.moveToZone(toZone, source, game, flag, appliedEffects)) {
            Zone currentZone = game.getState().getZone(this.getId());
            game.getState().setZone(this.getLeftHalfCard().getId(), currentZone);
            game.getState().setZone(this.getRightHalfCard().getId(), currentZone);
            return true;
        }
        return false;
    }

    @Override
    public void setZone(Zone zone, Game game) {
        super.setZone(zone, game);
        game.setZone(this.getLeftHalfCard().getId(), zone);
        game.setZone(this.getRightHalfCard().getId(), zone);
    }

    @Override
    public boolean moveToExile(UUID exileId, String name, Ability source, Game game, List<UUID> appliedEffects) {
        if (super.moveToExile(exileId, name, source, game, appliedEffects)) {
            Zone currentZone = game.getState().getZone(this.getId());
            game.getState().setZone(this.getLeftHalfCard().getId(), currentZone);
            game.getState().setZone(this.getRightHalfCard().getId(), currentZone);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeFromZone(Game game, Zone fromZone, Ability source) {
        return super.removeFromZone(game, fromZone, source);
    }

    @Override
    public void updateZoneChangeCounter(Game game, ZoneChangeEvent event) {
        if (this.isCopy()) {
            super.updateZoneChangeCounter(game, event);
            return;
        }
        super.updateZoneChangeCounter(game, event);
        this.getLeftHalfCard().updateZoneChangeCounter(game, event);
        this.getRightHalfCard().updateZoneChangeCounter(game, event);
    }

    @Override
    public boolean cast(Game game, Zone fromZone, SpellAbility ability, UUID controllerId) {
        switch (ability.getSpellAbilityType()) {
            case SPLIT_LEFT: {
                return this.getLeftHalfCard().cast(game, fromZone, ability, controllerId);
            }
            case SPLIT_RIGHT: {
                return this.getRightHalfCard().cast(game, fromZone, ability, controllerId);
            }
        }
        this.getLeftHalfCard().getSpellAbility().setControllerId(controllerId);
        this.getRightHalfCard().getSpellAbility().setControllerId(controllerId);
        return super.cast(game, fromZone, ability, controllerId);
    }

    @Override
    public Abilities<Ability> getAbilities() {
        AbilitiesImpl<Ability> allAbilites = new AbilitiesImpl<Ability>();
        for (Ability ability : super.getAbilities()) {
            if (ability instanceof SpellAbility && (((SpellAbility)ability).getSpellAbilityType() == SpellAbilityType.SPLIT || ((SpellAbility)ability).getSpellAbilityType() == SpellAbilityType.SPLIT_AFTERMATH)) continue;
            allAbilites.add(ability);
        }
        allAbilites.addAll(this.leftHalfCard.getAbilities());
        allAbilites.addAll(this.rightHalfCard.getAbilities());
        return allAbilites;
    }

    @Override
    public Abilities<Ability> getInitAbilities() {
        return super.getAbilities();
    }

    public Abilities<Ability> getSharedAbilities(Game game) {
        return super.getAbilities(game);
    }

    @Override
    public Abilities<Ability> getAbilities(Game game) {
        AbilitiesImpl<Ability> allAbilites = new AbilitiesImpl<Ability>();
        for (Ability ability : super.getAbilities(game)) {
            if (ability instanceof SpellAbility && (((SpellAbility)ability).getSpellAbilityType() == SpellAbilityType.SPLIT || ((SpellAbility)ability).getSpellAbilityType() == SpellAbilityType.SPLIT_AFTERMATH)) continue;
            allAbilites.add(ability);
        }
        allAbilites.addAll(this.leftHalfCard.getAbilities(game));
        allAbilites.addAll(this.rightHalfCard.getAbilities(game));
        return allAbilites;
    }

    @Override
    public List<String> getRules() {
        Abilities<Ability> sourceAbilities = this.getAbilities();
        List<String> res = CardUtil.getCardRulesWithAdditionalInfo(this, sourceAbilities, sourceAbilities);
        if (this.getSpellAbility().getSpellAbilityType() == SpellAbilityType.SPLIT_FUSED) {
            res.add("--------------------------------------------------------------------------\nFuse <i>(You may cast one or both halves of this card from your hand.)</i>");
        }
        return res;
    }

    @Override
    public List<String> getRules(Game game) {
        Abilities<Ability> sourceAbilities = this.getAbilities(game);
        List<String> res = CardUtil.getCardRulesWithAdditionalInfo(game, this, sourceAbilities, sourceAbilities);
        if (this.getSpellAbility().getSpellAbilityType() == SpellAbilityType.SPLIT_FUSED) {
            res.add("--------------------------------------------------------------------------\nFuse <i>(You may cast one or both halves of this card from your hand.)</i>");
        }
        return res;
    }

    @Override
    public void setOwnerId(UUID ownerId) {
        super.setOwnerId(ownerId);
        this.abilities.setControllerId(ownerId);
        this.leftHalfCard.getAbilities().setControllerId(ownerId);
        this.leftHalfCard.setOwnerId(ownerId);
        this.rightHalfCard.getAbilities().setControllerId(ownerId);
        this.rightHalfCard.setOwnerId(ownerId);
    }

    @Override
    public int getManaValue() {
        return super.getManaValue();
    }
}

