/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.decks;

import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import mage.cards.decks.DeckValidator;
import org.apache.log4j.Logger;

public enum DeckValidatorFactory {
    instance;

    private static final Logger logger;
    private final Map<String, Class> deckTypes = new LinkedHashMap<String, Class>();

    public DeckValidator createDeckValidator(String deckType) {
        DeckValidator validator;
        try {
            Constructor con = this.deckTypes.get(deckType).getConstructor(new Class[0]);
            validator = (DeckValidator)con.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            logger.fatal((Object)"DeckValidatorFactory error", (Throwable)ex);
            return null;
        }
        logger.debug((Object)("Deck validator created: " + validator.getName()));
        return validator;
    }

    public Set<String> getDeckTypes() {
        return this.deckTypes.keySet();
    }

    public void addDeckType(String name, Class deckType) {
        if (deckType != null) {
            this.deckTypes.put(name, deckType);
        }
    }

    static {
        logger = Logger.getLogger(DeckValidatorFactory.class);
    }
}

