/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.decks.importer;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mage.cards.decks.DeckCardInfo;
import mage.cards.decks.DeckCardLists;
import mage.cards.decks.importer.CardLookup;
import mage.cards.decks.importer.XmlDeckImporter;
import mage.cards.repository.CardInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CodDeckImporter
extends XmlDeckImporter {
    @Override
    public DeckCardLists importDeck(String fileName, StringBuilder errorMessages, boolean saveAutoFixedFile) {
        try {
            Document doc = this.getXmlDocument(fileName);
            DeckCardLists decklist = new DeckCardLists();
            List<Node> mainCards = this.getNodes(doc, "/cockatrice_deck/zone[@name='main']/card");
            decklist.setCards(mainCards.stream().flatMap(CodDeckImporter.toDeckCardInfo(this.getCardLookup(), errorMessages)).collect(Collectors.toList()));
            List<Node> sideboardCards = this.getNodes(doc, "/cockatrice_deck/zone[@name='side']/card");
            decklist.setSideboard(sideboardCards.stream().flatMap(CodDeckImporter.toDeckCardInfo(this.getCardLookup(), errorMessages)).collect(Collectors.toList()));
            this.getNodes(doc, "/cockatrice_deck/deckname").forEach(n -> decklist.setName(n.getTextContent().trim()));
            return decklist;
        }
        catch (Exception e) {
            logger.error((Object)"Error loading deck", (Throwable)e);
            errorMessages.append("There was an error loading the deck: " + e.getMessage());
            return new DeckCardLists();
        }
    }

    private static int getQuantityFromNode(Node node) {
        Node numberNode = node.getAttributes().getNamedItem("number");
        if (numberNode == null) {
            return 1;
        }
        try {
            return Math.min(100, Math.max(1, Integer.parseInt(numberNode.getNodeValue())));
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    private static Function<Node, Stream<DeckCardInfo>> toDeckCardInfo(CardLookup lookup, StringBuilder errors) {
        return node -> {
            String name = node.getAttributes().getNamedItem("name").getNodeValue().trim();
            CardInfo cardInfo = lookup.lookupCardInfo(name);
            if (cardInfo != null) {
                int amount = CodDeckImporter.getQuantityFromNode(node);
                DeckCardInfo.makeSureCardAmountFine(amount, cardInfo.getName());
                return Collections.nCopies(amount, new DeckCardInfo(cardInfo.getName(), cardInfo.getCardNumber(), cardInfo.getSetCode())).stream();
            }
            errors.append("Could not find card: '").append(name).append("'\n");
            return Stream.empty();
        };
    }
}

