/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.decks.importer;

import mage.cards.decks.DeckCardInfo;
import mage.cards.decks.DeckCardLists;
import mage.cards.decks.importer.DeckImporter;
import mage.cards.decks.importer.PlainTextDeckImporter;
import mage.cards.repository.CardInfo;

public class DekDeckImporter
extends PlainTextDeckImporter {
    @Override
    protected void readLine(String line, DeckCardLists deckList, DeckImporter.FixedInfo fixedInfo) {
        if (line.isEmpty() || line.startsWith("#") || !line.contains("<Cards ")) {
            return;
        }
        try {
            Integer cardCount = Integer.parseInt(this.extractAttribute(line, "Quantity"));
            String cardName = this.extractAttribute(line, "Name");
            DeckCardInfo.makeSureCardAmountFine(cardCount, cardName);
            if (!cardName.contains("//") && cardName.contains("/")) {
                cardName = cardName.replace("/", " // ");
            }
            boolean isSideboard = "true".equals(this.extractAttribute(line, "Sideboard"));
            CardInfo cardInfo = this.getCardLookup().lookupCardInfo(cardName);
            if (cardInfo == null) {
                this.sbMessage.append("Could not find card: '").append(cardName).append("' at line ").append(this.lineCount).append('\n');
            } else {
                DeckCardInfo deckCardInfo = new DeckCardInfo(cardInfo.getName(), cardInfo.getCardNumber(), cardInfo.getSetCode());
                for (int i = 0; i < cardCount; ++i) {
                    if (isSideboard) {
                        deckList.getSideboard().add(deckCardInfo.copy());
                        continue;
                    }
                    deckList.getCards().add(deckCardInfo.copy());
                }
            }
        }
        catch (NumberFormatException nfe) {
            this.sbMessage.append("Invalid number: ").append(this.extractAttribute(line, "Quantity")).append(" at line ").append(this.lineCount).append('\n');
        }
    }

    private String extractAttribute(String line, String name) {
        String searchString = name + "=\"";
        int startDelim = line.indexOf(searchString) + searchString.length();
        int endDelim = line.substring(startDelim).indexOf(34);
        return line.substring(startDelim, startDelim + endDelim);
    }
}

