/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.decks.importer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import mage.cards.decks.DeckCardLists;
import mage.cards.decks.importer.DeckImporter;

public abstract class PlainTextDeckImporter
extends DeckImporter {
    protected StringBuilder sbMessage = new StringBuilder();
    protected int lineCount;

    @Override
    public DeckCardLists importDeck(String fileName, StringBuilder errorMessages, boolean saveAutoFixedFile) {
        File f = new File(fileName);
        ArrayList<String> originalFile = new ArrayList<String>();
        ArrayList<String> fixedFile = new ArrayList<String>();
        DeckCardLists deckList = new DeckCardLists();
        if (!f.exists()) {
            logger.warn((Object)("Deckfile " + fileName + " not found."));
            return deckList;
        }
        this.lineCount = 0;
        this.sbMessage.setLength(0);
        try {
            try (Scanner scanner = new Scanner(f);){
                boolean canFix = true;
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine().trim();
                    DeckImporter.FixedInfo fixedInfo = new DeckImporter.FixedInfo(line);
                    ++this.lineCount;
                    this.readLine(line, deckList, fixedInfo);
                    originalFile.add(line);
                    fixedFile.add(fixedInfo.getFixedLine());
                    canFix = canFix && fixedInfo.getCanFix() != false;
                }
                if (saveAutoFixedFile && canFix && !originalFile.equals(fixedFile)) {
                    logger.warn((Object)("WARNING, deck file contains errors, try to apply auto-fix and save: " + f.getAbsolutePath()));
                    this.saveFixedDeckFile(fixedFile, f);
                }
                if (deckList.getCards().isEmpty() && deckList.getSideboard().isEmpty()) {
                    this.sbMessage.append("ERROR, unknown deck format, can't find any cards").append("\n");
                }
                if (this.sbMessage.length() > 0) {
                    if (errorMessages != null) {
                        errorMessages.append((CharSequence)this.sbMessage);
                    } else {
                        logger.fatal((Object)this.sbMessage);
                    }
                }
            }
            catch (Exception ex) {
                logger.fatal(null, (Throwable)ex);
            }
        }
        catch (Exception ex) {
            logger.fatal(null, (Throwable)ex);
        }
        return deckList;
    }

    private void saveFixedDeckFile(List<String> fixedfile, File file) {
        try (FileOutputStream stream = new FileOutputStream(file);){
            PrintWriter out = new PrintWriter(stream);
            for (String line : fixedfile) {
                out.println(line);
            }
            out.close();
        }
        catch (Exception e) {
            logger.error((Object)("Can't save fixed deck file: " + file.getAbsolutePath() + ", reason: " + e.getMessage()));
        }
    }

    @Override
    public DeckCardLists importDeck(String fileName, boolean saveAutoFixedFile) {
        return this.importDeck(fileName, null, saveAutoFixedFile);
    }

    protected abstract void readLine(String var1, DeckCardLists var2, DeckImporter.FixedInfo var3);
}

