/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.repository;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.dao.GenericRawResults;
import com.j256.ormlite.jdbc.JdbcConnectionSource;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.stmt.Where;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.table.TableUtils;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import mage.cards.repository.CardCriteria;
import mage.cards.repository.CardInfo;
import mage.cards.repository.DatabaseUtils;
import mage.cards.repository.ExpansionInfo;
import mage.cards.repository.ExpansionRepository;
import mage.cards.repository.RepositoryUtil;
import mage.constants.CardType;
import mage.constants.SetType;
import mage.constants.SuperType;
import mage.util.RandomUtil;
import org.apache.log4j.Logger;

public enum CardRepository {
    instance;

    private static final Logger logger;
    private static final AtomicInteger databaseFixes;
    private static final int MAX_DATABASE_FIXES = 10;
    private static final String VERSION_ENTITY_NAME = "card";
    private static final long CARD_DB_VERSION = 54L;
    private static final long CARD_CONTENT_VERSION = 241L;
    private Dao<CardInfo, Object> cardsDao;
    private static final Map<String, Set<String>> namesQueryCache;
    public static final Set<String> snowLandSetCodes;

    private CardRepository() {
        File file = new File("db");
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            JdbcConnectionSource connectionSource = new JdbcConnectionSource(DatabaseUtils.prepareH2Connection("cards.h2", true));
            boolean isObsolete = RepositoryUtil.isDatabaseObsolete((ConnectionSource)connectionSource, VERSION_ENTITY_NAME, 54L);
            boolean isNewBuild = RepositoryUtil.isNewBuildRun((ConnectionSource)connectionSource, VERSION_ENTITY_NAME, CardRepository.class);
            if (isObsolete || isNewBuild) {
                TableUtils.dropTable((ConnectionSource)connectionSource, CardInfo.class, (boolean)true);
            }
            TableUtils.createTableIfNotExists((ConnectionSource)connectionSource, CardInfo.class);
            this.cardsDao = DaoManager.createDao((ConnectionSource)connectionSource, CardInfo.class);
        }
        catch (SQLException e) {
            Logger.getLogger(CardRepository.class).error((Object)("Error creating card repository - " + e), (Throwable)e);
            this.processMemoryErrors(e);
        }
    }

    private void processMemoryErrors(Exception e) {
        if (e.toString().contains("file") || e.toString().contains("closed")) {
            CardRepository.checkDatabaseHealthAndFix();
        }
    }

    public void saveCards(List<CardInfo> newCards, long newContentVersion) {
        if (newCards == null || newCards.isEmpty()) {
            return;
        }
        try {
            this.cardsDao.callBatchTasks(() -> {
                logger.info((Object)("DB: need to add " + newCards.size() + " new cards"));
                try {
                    for (CardInfo card : newCards) {
                        this.cardsDao.create((Object)card);
                    }
                }
                catch (SQLException e) {
                    Logger.getLogger(CardRepository.class).error((Object)("Error adding cards to DB - " + e), (Throwable)e);
                    this.processMemoryErrors(e);
                }
                return null;
            });
            this.setContentVersion(newContentVersion);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addNewNames(CardInfo card, Set<String> namesList) {
        int result = card.getName().indexOf(" // ");
        if (result > 0) {
            namesList.add(card.getName().substring(0, result));
            namesList.add(card.getName().substring(result + 4));
        } else {
            namesList.add(card.getName());
        }
        if (card.getSecondSideName() != null && !card.getSecondSideName().isEmpty()) {
            namesList.add(card.getSecondSideName());
        }
        if (card.getModalDoubleFacedSecondSideName() != null && !card.getModalDoubleFacedSecondSideName().isEmpty()) {
            namesList.add(card.getModalDoubleFacedSecondSideName());
        }
        if (card.getFlipCardName() != null && !card.getFlipCardName().isEmpty()) {
            namesList.add(card.getFlipCardName());
        }
        if (card.getMeldsToCardName() != null && !card.getMeldsToCardName().isEmpty()) {
            namesList.add(card.getMeldsToCardName());
        }
        if (card.getSpellOptionCardName() != null && !card.getSpellOptionCardName().isEmpty()) {
            namesList.add(card.getSpellOptionCardName());
        }
    }

    public static Boolean haveSnowLands(String setCode) {
        return snowLandSetCodes.contains(setCode);
    }

    public synchronized Set<String> getNames() {
        Set names = namesQueryCache.computeIfAbsent("getNames", x -> new TreeSet());
        if (!names.isEmpty()) {
            return names;
        }
        try {
            QueryBuilder qb = this.cardsDao.queryBuilder();
            qb.distinct().selectColumns(new String[]{"name", "modalDoubleFacedSecondSideName", "secondSideName", "flipCardName", "spellOptionCardName"});
            List results = this.cardsDao.query(qb.prepare());
            for (CardInfo card : results) {
                this.addNewNames(card, names);
            }
        }
        catch (SQLException e) {
            Logger.getLogger(CardRepository.class).error((Object)("Error getting names from DB, possible low memory: " + e), (Throwable)e);
            this.processMemoryErrors(e);
        }
        return names;
    }

    public synchronized Set<String> getNonLandNames() {
        Set names = namesQueryCache.computeIfAbsent("getNonLandNames", x -> new TreeSet());
        if (!names.isEmpty()) {
            return names;
        }
        try {
            QueryBuilder qb = this.cardsDao.queryBuilder();
            qb.distinct().selectColumns(new String[]{"name", "modalDoubleFacedSecondSideName", "secondSideName", "flipCardName", "spellOptionCardName"});
            qb.where().not().like("types", (Object)new SelectArg((Object)('%' + CardType.LAND.name() + '%')));
            List results = this.cardsDao.query(qb.prepare());
            for (CardInfo card : results) {
                this.addNewNames(card, names);
            }
        }
        catch (SQLException e) {
            Logger.getLogger(CardRepository.class).error((Object)("Error getting non-land names from DB, possible low memory: " + e), (Throwable)e);
            this.processMemoryErrors(e);
        }
        return names;
    }

    public synchronized Set<String> getNonbasicLandNames() {
        Set names = namesQueryCache.computeIfAbsent("getNonbasicLandNames", x -> new TreeSet());
        if (!names.isEmpty()) {
            return names;
        }
        try {
            QueryBuilder qb = this.cardsDao.queryBuilder();
            qb.distinct().selectColumns(new String[]{"name", "modalDoubleFacedSecondSideName", "secondSideName", "flipCardName", "spellOptionCardName"});
            Where where = qb.where();
            where.and(where.not().like("supertypes", (Object)('%' + SuperType.BASIC.name() + '%')), where.like("types", (Object)('%' + CardType.LAND.name() + '%')));
            List results = this.cardsDao.query(qb.prepare());
            for (CardInfo card : results) {
                this.addNewNames(card, names);
            }
        }
        catch (SQLException e) {
            Logger.getLogger(CardRepository.class).error((Object)("Error getting non-land names from DB, possible low memory: " + e), (Throwable)e);
            this.processMemoryErrors(e);
        }
        return names;
    }

    public synchronized Set<String> getNotBasicLandNames() {
        Set names = namesQueryCache.computeIfAbsent("getNotBasicLandNames", x -> new TreeSet());
        if (!names.isEmpty()) {
            return names;
        }
        try {
            QueryBuilder qb = this.cardsDao.queryBuilder();
            qb.distinct().selectColumns(new String[]{"name", "modalDoubleFacedSecondSideName", "secondSideName", "flipCardName", "spellOptionCardName"});
            qb.where().not().like("supertypes", (Object)new SelectArg((Object)('%' + SuperType.BASIC.name() + '%')));
            List results = this.cardsDao.query(qb.prepare());
            for (CardInfo card : results) {
                this.addNewNames(card, names);
            }
        }
        catch (SQLException e) {
            Logger.getLogger(CardRepository.class).error((Object)("Error getting non-land names from DB, possible low memory: " + e), (Throwable)e);
            this.processMemoryErrors(e);
        }
        return names;
    }

    public synchronized Set<String> getCreatureNames() {
        Set names = namesQueryCache.computeIfAbsent("getCreatureNames", x -> new TreeSet());
        if (!names.isEmpty()) {
            return names;
        }
        try {
            QueryBuilder qb = this.cardsDao.queryBuilder();
            qb.distinct().selectColumns(new String[]{"name", "modalDoubleFacedSecondSideName", "secondSideName", "flipCardName", "spellOptionCardName"});
            qb.where().like("types", (Object)new SelectArg((Object)('%' + CardType.CREATURE.name() + '%')));
            List results = this.cardsDao.query(qb.prepare());
            for (CardInfo card : results) {
                this.addNewNames(card, names);
            }
        }
        catch (SQLException e) {
            Logger.getLogger(CardRepository.class).error((Object)("Error getting creature names from DB, possible low memory: " + e), (Throwable)e);
            this.processMemoryErrors(e);
        }
        return names;
    }

    public synchronized Set<String> getArtifactNames() {
        Set names = namesQueryCache.computeIfAbsent("getArtifactNames", x -> new TreeSet());
        if (!names.isEmpty()) {
            return names;
        }
        try {
            QueryBuilder qb = this.cardsDao.queryBuilder();
            qb.distinct().selectColumns(new String[]{"name", "modalDoubleFacedSecondSideName", "secondSideName", "flipCardName", "spellOptionCardName"});
            qb.where().like("types", (Object)new SelectArg((Object)('%' + CardType.ARTIFACT.name() + '%')));
            List results = this.cardsDao.query(qb.prepare());
            for (CardInfo card : results) {
                this.addNewNames(card, names);
            }
        }
        catch (SQLException e) {
            Logger.getLogger(CardRepository.class).error((Object)("Error getting artifact names from DB, possible low memory: " + e), (Throwable)e);
            this.processMemoryErrors(e);
        }
        return names;
    }

    public synchronized Set<String> getNonLandAndNonCreatureNames() {
        Set names = namesQueryCache.computeIfAbsent("getNonLandAndNonCreatureNames", x -> new TreeSet());
        if (!names.isEmpty()) {
            return names;
        }
        try {
            QueryBuilder qb = this.cardsDao.queryBuilder();
            qb.distinct().selectColumns(new String[]{"name", "modalDoubleFacedSecondSideName", "secondSideName", "flipCardName", "spellOptionCardName"});
            Where where = qb.where();
            where.and(where.not().like("types", (Object)('%' + CardType.CREATURE.name() + '%')), where.not().like("types", (Object)('%' + CardType.LAND.name() + '%')));
            List results = this.cardsDao.query(qb.prepare());
            for (CardInfo card : results) {
                this.addNewNames(card, names);
            }
        }
        catch (SQLException e) {
            Logger.getLogger(CardRepository.class).error((Object)("Error getting non-land and non-creature names from DB, possible low memory: " + e), (Throwable)e);
            this.processMemoryErrors(e);
        }
        return names;
    }

    public synchronized Set<String> getNonArtifactAndNonLandNames() {
        Set names = namesQueryCache.computeIfAbsent("getNonArtifactAndNonLandNames", x -> new TreeSet());
        if (!names.isEmpty()) {
            return names;
        }
        try {
            QueryBuilder qb = this.cardsDao.queryBuilder();
            qb.distinct().selectColumns(new String[]{"name", "modalDoubleFacedSecondSideName", "secondSideName", "flipCardName", "spellOptionCardName"});
            Where where = qb.where();
            where.and(where.not().like("types", (Object)('%' + CardType.ARTIFACT.name() + '%')), where.not().like("types", (Object)('%' + CardType.LAND.name() + '%')));
            List results = this.cardsDao.query(qb.prepare());
            for (CardInfo card : results) {
                this.addNewNames(card, names);
            }
        }
        catch (SQLException e) {
            Logger.getLogger(CardRepository.class).error((Object)("Error getting non-artifact non-land names from DB, possible low memory: " + e), (Throwable)e);
            this.processMemoryErrors(e);
        }
        return names;
    }

    public CardInfo findCard(String setCode, String cardNumber) {
        return this.findCard(setCode, cardNumber, true);
    }

    public CardInfo findCard(String setCode, String cardNumber, boolean ignoreNightCards) {
        try {
            QueryBuilder queryBuilder = this.cardsDao.queryBuilder();
            if (ignoreNightCards) {
                queryBuilder.limit(Long.valueOf(1L)).where().eq("setCode", (Object)new SelectArg((Object)setCode)).and().eq("cardNumber", (Object)new SelectArg((Object)cardNumber)).and().eq("nightCard", (Object)new SelectArg((Object)false));
            } else {
                queryBuilder.limit(Long.valueOf(1L)).where().eq("setCode", (Object)new SelectArg((Object)setCode)).and().eq("cardNumber", (Object)new SelectArg((Object)cardNumber));
                queryBuilder.orderBy("nightCard", true);
            }
            List result = this.cardsDao.query(queryBuilder.prepare());
            if (!result.isEmpty()) {
                return (CardInfo)result.get(0);
            }
        }
        catch (SQLException e) {
            Logger.getLogger(CardRepository.class).error((Object)("Error finding card from DB: " + e), (Throwable)e);
            this.processMemoryErrors(e);
        }
        return null;
    }

    public List<String> getClassNames() {
        ArrayList<String> names = new ArrayList<String>();
        try {
            List results = this.cardsDao.queryForAll();
            for (CardInfo card : results) {
                names.add(card.getClassName());
            }
        }
        catch (SQLException e) {
            Logger.getLogger(CardRepository.class).error((Object)("Error getting classnames from DB, possible low memory:" + e), (Throwable)e);
            this.processMemoryErrors(e);
        }
        return names;
    }

    public List<CardInfo> getMissingCards(List<String> classNames) {
        try {
            QueryBuilder queryBuilder = this.cardsDao.queryBuilder();
            queryBuilder.where().not().in("className", classNames);
            return this.cardsDao.query(queryBuilder.prepare());
        }
        catch (SQLException e) {
            Logger.getLogger(CardRepository.class).error((Object)("Error getting missing cards from DB: " + e), (Throwable)e);
            this.processMemoryErrors(e);
            return Collections.emptyList();
        }
    }

    public CardInfo findCard(String name) {
        return this.findCard(name, false);
    }

    public CardInfo findCard(String name, boolean returnAnySet) {
        List<CardInfo> cards;
        List<CardInfo> list = cards = returnAnySet ? this.findCards(name, 1L) : this.findCards(name);
        if (!cards.isEmpty()) {
            return cards.get(RandomUtil.nextInt(cards.size()));
        }
        return null;
    }

    public CardInfo findPreferredCoreExpansionCard(String name) {
        return this.findPreferredCoreExpansionCard(name, "");
    }

    public CardInfo findPreferredCoreExpansionCard(String name, String preferredSetCode) {
        List<CardInfo> cards = this.findCards(name);
        return this.findPreferredOrLatestCard(cards, preferredSetCode);
    }

    private CardInfo findPreferredOrLatestCard(List<CardInfo> cards, String preferredSetCode) {
        if (!cards.isEmpty()) {
            Date lastReleaseDate = null;
            Date lastExpansionDate = null;
            CardInfo cardToUse = null;
            for (CardInfo cardinfo : cards) {
                ExpansionInfo set = ExpansionRepository.instance.getSetByCode(cardinfo.getSetCode());
                if (set == null) continue;
                if (preferredSetCode.equals(set.getCode())) {
                    return cardinfo;
                }
                if (set.getType().isStandardLegal() && (lastExpansionDate == null || set.getReleaseDate().after(lastExpansionDate))) {
                    cardToUse = cardinfo;
                    lastExpansionDate = set.getReleaseDate();
                }
                if (lastExpansionDate != null || lastReleaseDate != null && !set.getReleaseDate().after(lastReleaseDate)) continue;
                cardToUse = cardinfo;
                lastReleaseDate = set.getReleaseDate();
            }
            return cardToUse;
        }
        return null;
    }

    public CardInfo findCardWithPreferredSetAndNumber(String name, String expansion, String cardNumber, boolean returnSplitCardHalf) {
        List<CardInfo> cards = this.findCards(name, 0L, returnSplitCardHalf, true);
        CardInfo bestCard = cards.stream().filter(card -> expansion == null || expansion.equalsIgnoreCase(card.getSetCode())).filter(card -> cardNumber == null || cardNumber.equals(card.getCardNumber())).findFirst().orElse(null);
        if (bestCard != null) {
            return bestCard;
        }
        return this.findPreferredCoreExpansionCard(name);
    }

    public CardInfo findCardWithPreferredSetAndNumber(String name, String expansion, String cardNumber) {
        return this.findCardWithPreferredSetAndNumber(name, expansion, cardNumber, false);
    }

    public List<CardInfo> findCards(String name) {
        return this.findCards(name, 0L);
    }

    public List<CardInfo> findCards(String name, long limitByMaxAmount, boolean returnSplitCardHalf, boolean canCheckDatabaseHealth) {
        QueryBuilder queryBuilder = this.cardsDao.queryBuilder();
        if (limitByMaxAmount > 0L) {
            queryBuilder.limit(Long.valueOf(limitByMaxAmount));
        }
        try {
            List results;
            if (name.contains(" // ")) {
                queryBuilder.where().eq("name", (Object)new SelectArg((Object)name));
                results = this.cardsDao.query(queryBuilder.prepare());
                if (results.isEmpty()) {
                    String mainCardName = name.split(" // ", 2)[0];
                    queryBuilder.where().eq("name", (Object)new SelectArg((Object)mainCardName));
                    results = this.cardsDao.query(queryBuilder.prepare());
                }
            } else {
                queryBuilder.where().eq("name", (Object)new SelectArg((Object)name));
                results = this.cardsDao.query(queryBuilder.prepare());
                if (results.isEmpty()) {
                    queryBuilder.where().eq("flipCardName", (Object)new SelectArg((Object)name)).or().eq("secondSideName", (Object)new SelectArg((Object)name)).or().eq("spellOptionCardName", (Object)new SelectArg((Object)name)).or().eq("modalDoubleFacedSecondSideName", (Object)new SelectArg((Object)name));
                    results = this.cardsDao.query(queryBuilder.prepare());
                } else {
                    CardInfo firstCardInfo = (CardInfo)results.get(0);
                    if (firstCardInfo.isSplitCardHalf() && !returnSplitCardHalf) {
                        queryBuilder.where().eq("setCode", (Object)new SelectArg((Object)firstCardInfo.setCode)).and().eq("cardNumber", (Object)new SelectArg((Object)firstCardInfo.cardNumber));
                        List tmpResults = this.cardsDao.query(queryBuilder.prepare());
                        String fullSplitCardName = null;
                        for (CardInfo cardInfo : tmpResults) {
                            if (!cardInfo.isSplitCard()) continue;
                            fullSplitCardName = cardInfo.name;
                            break;
                        }
                        if (fullSplitCardName == null) {
                            return Collections.emptyList();
                        }
                        queryBuilder.where().eq("name", (Object)new SelectArg(fullSplitCardName));
                        results = this.cardsDao.query(queryBuilder.prepare());
                    }
                }
            }
            return results;
        }
        catch (SQLException e) {
            Logger.getLogger(CardRepository.class).error((Object)("Error during execution of raw sql statement: " + e), (Throwable)e);
            if (canCheckDatabaseHealth) {
                this.processMemoryErrors(e);
            }
            return Collections.emptyList();
        }
    }

    public List<CardInfo> findCards(String name, long limitByMaxAmount) {
        return this.findCards(name, limitByMaxAmount, false, true);
    }

    public List<CardInfo> findCardsByClass(String canonicalClassName) {
        try {
            QueryBuilder queryBuilder = this.cardsDao.queryBuilder();
            queryBuilder.where().eq("className", (Object)new SelectArg((Object)canonicalClassName));
            return this.cardsDao.query(queryBuilder.prepare());
        }
        catch (SQLException e) {
            Logger.getLogger(CardRepository.class).error((Object)("Error during execution of raw sql statement" + e), (Throwable)e);
            this.processMemoryErrors(e);
            return Collections.emptyList();
        }
    }

    public List<CardInfo> findCards(CardCriteria criteria) {
        try {
            QueryBuilder queryBuilder = this.cardsDao.queryBuilder();
            criteria.buildQuery(queryBuilder);
            return this.cardsDao.query(queryBuilder.prepare());
        }
        catch (SQLException e) {
            Logger.getLogger(CardRepository.class).error((Object)("Error during execution of card repository query statement: " + e), (Throwable)e);
            this.processMemoryErrors(e);
            return Collections.emptyList();
        }
    }

    public CardInfo findOldestNonPromoVersionCard(String name) {
        List<CardInfo> allVersions = this.findCards(name);
        if (!allVersions.isEmpty()) {
            allVersions.sort(new OldestNonPromoComparator());
            return allVersions.get(0);
        }
        return null;
    }

    public long getContentVersionFromDB() {
        try {
            JdbcConnectionSource connectionSource = new JdbcConnectionSource(DatabaseUtils.prepareH2Connection("cards.h2", false));
            return RepositoryUtil.getDatabaseVersion((ConnectionSource)connectionSource, "cardContent");
        }
        catch (SQLException e) {
            Logger.getLogger(CardRepository.class).error((Object)("Error getting content version from DB - " + e), (Throwable)e);
            this.processMemoryErrors(e);
            return 0L;
        }
    }

    public void setContentVersion(long version) {
        try {
            JdbcConnectionSource connectionSource = new JdbcConnectionSource(DatabaseUtils.prepareH2Connection("cards.h2", false));
            RepositoryUtil.updateVersion((ConnectionSource)connectionSource, "cardContent", version);
        }
        catch (SQLException e) {
            Logger.getLogger(CardRepository.class).error((Object)("Error setting content version - " + e), (Throwable)e);
            this.processMemoryErrors(e);
        }
    }

    public long getContentVersionConstant() {
        return 241L;
    }

    public void closeDB(boolean writeCompact) {
        try {
            if (this.cardsDao != null && this.cardsDao.getConnectionSource() != null) {
                DatabaseConnection conn = this.cardsDao.getConnectionSource().getReadWriteConnection(this.cardsDao.getTableName());
                if (writeCompact) {
                    conn.executeStatement("SHUTDOWN COMPACT", -1);
                } else {
                    conn.executeStatement("SHUTDOWN IMMEDIATELY", -1);
                }
                this.cardsDao.getConnectionSource().releaseConnection(conn);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void openDB() {
        try {
            JdbcConnectionSource connectionSource = new JdbcConnectionSource(DatabaseUtils.prepareH2Connection("cards.h2", true));
            this.cardsDao = DaoManager.createDao((ConnectionSource)connectionSource, CardInfo.class);
        }
        catch (SQLException e) {
            Logger.getLogger(CardRepository.class).error((Object)("Error opening card repository - " + e), (Throwable)e);
        }
    }

    public void printDatabaseStats(String info) {
        List<List<String>> allSettings = this.querySQL("SELECT NAME, VALUE FROM INFORMATION_SCHEMA.SETTINGS");
        if (allSettings == null) {
            return;
        }
        logger.info((Object)("Database cache settings (" + info + "):"));
        allSettings.stream().filter(values -> ((String)values.get(0)).equals("CACHE_SIZE")).forEach(values -> logger.info((Object)(" - cache size, setup: " + (String)values.get(1) + " kb")));
        allSettings.stream().filter(values -> ((String)values.get(0)).equals("info.CACHE_MAX_SIZE")).forEach(values -> logger.info((Object)(" - cache size, max: " + (String)values.get(1) + " mb")));
        allSettings.stream().filter(values -> ((String)values.get(0)).equals("info.CACHE_SIZE")).forEach(values -> logger.info((Object)(" - cache size, current: " + (String)values.get(1) + " mb")));
        allSettings = this.querySQL("SELECT MEMORY_FREE(), MEMORY_USED()");
        if (allSettings == null) {
            return;
        }
        logger.info((Object)("Database memory stats (" + info + "):"));
        logger.info((Object)(" - free: " + allSettings.get(0).get(0) + " kb"));
        logger.info((Object)(" - used: " + allSettings.get(0).get(1) + " kb"));
    }

    public List<List<String>> querySQL(String sql) {
        try {
            GenericRawResults query = this.cardsDao.queryRaw(sql, new String[0]);
            return query.getResults().stream().map(Arrays::asList).collect(Collectors.toList());
        }
        catch (SQLException e) {
            logger.error((Object)("Can't query sql due error: " + sql + " - " + e), (Throwable)e);
            return null;
        }
    }

    public void execSQL(String sql) {
        try {
            this.cardsDao.executeRaw(sql, new String[0]);
        }
        catch (SQLException e) {
            logger.error((Object)("Can't exec sql due error: " + sql + " - " + e), (Throwable)e);
        }
    }

    private static CardInfo safeFindKnownCard() {
        return instance.findCards("Silvercoat Lion", 1L, false, false).stream().findFirst().orElse(null);
    }

    public static boolean checkDatabaseHealthAndFix() {
        CardInfo cardInfo = CardRepository.safeFindKnownCard();
        if (cardInfo != null) {
            logger.info((Object)"Database: checking broken status... GOOD");
            return true;
        }
        Logger.getLogger(CardRepository.class).error((Object)"Database: checking broken status... BAD");
        if (databaseFixes.incrementAndGet() > 10) {
            logger.error((Object)"Critical error: no more db memory fixes allows, server must be restarted");
            return false;
        }
        instance.closeDB(false);
        instance.openDB();
        cardInfo = CardRepository.safeFindKnownCard();
        if (cardInfo != null) {
            logger.warn((Object)String.format("Database: trying to restart (%d try)... GOOD - db fixed", databaseFixes.get()));
            return true;
        }
        logger.warn((Object)String.format("Database: trying to restart  (%d try)... FAIL - server must be restarted", databaseFixes.get()));
        return false;
    }

    static {
        logger = Logger.getLogger(CardRepository.class);
        databaseFixes = new AtomicInteger();
        namesQueryCache = new HashMap<String, Set<String>>();
        snowLandSetCodes = new HashSet<String>(Arrays.asList("CSP", "MH1", "ME2", "MB2"));
    }

    static class OldestNonPromoComparator
    implements Comparator<CardInfo> {
        OldestNonPromoComparator() {
        }

        @Override
        public int compare(CardInfo a, CardInfo b) {
            ExpansionInfo aSet = ExpansionRepository.instance.getSetByCode(a.getSetCode());
            ExpansionInfo bSet = ExpansionRepository.instance.getSetByCode(b.getSetCode());
            if (aSet.getType() == SetType.PROMOTIONAL && bSet.getType() != SetType.PROMOTIONAL) {
                return 1;
            }
            if (bSet.getType() == SetType.PROMOTIONAL && aSet.getType() != SetType.PROMOTIONAL) {
                return -1;
            }
            if (aSet.getReleaseDate().after(bSet.getReleaseDate())) {
                return 1;
            }
            if (aSet.getReleaseDate().before(bSet.getReleaseDate())) {
                return -1;
            }
            return Integer.compare(a.getCardNumberAsInt(), b.getCardNumberAsInt());
        }
    }
}

