/*
 * Decompiled with CFR 0.152.
 */
package mage.choices;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.choices.Choice;
import mage.choices.ChoiceHintType;
import mage.game.Game;
import mage.util.CardUtil;
import mage.util.RandomUtil;
import org.apache.log4j.Logger;

public class ChoiceImpl
implements Choice {
    private static final Logger logger = Logger.getLogger(Choice.class);
    protected boolean chosenNormal;
    protected boolean chosenSpecial;
    protected boolean required;
    protected String choice;
    protected String choiceKey;
    protected Set<String> choices = new LinkedHashSet<String>();
    protected Map<String, String> keyChoices = new LinkedHashMap<String, String>();
    protected Map<String, Integer> sortData = new LinkedHashMap<String, Integer>();
    protected Map<String, List<String>> hintData = new LinkedHashMap<String, List<String>>();
    protected String message;
    protected String subMessage;
    protected boolean searchEnabled = true;
    protected String searchText;
    protected ChoiceHintType hintType;
    protected boolean specialEnabled = false;
    protected boolean specialCanBeEmpty = false;
    protected String specialText = "";
    protected String specialHint = "";
    protected boolean manaColorChoice = false;

    public ChoiceImpl(boolean required) {
        this(required, ChoiceHintType.TEXT);
    }

    public ChoiceImpl(boolean required, ChoiceHintType hintType) {
        this.required = required;
        this.hintType = hintType;
    }

    protected ChoiceImpl(ChoiceImpl choice) {
        this.choice = choice.choice;
        this.chosenNormal = choice.chosenNormal;
        this.chosenSpecial = choice.chosenSpecial;
        this.required = choice.required;
        this.message = choice.message;
        this.subMessage = choice.subMessage;
        this.searchEnabled = choice.searchEnabled;
        this.searchText = choice.searchText;
        this.hintType = choice.hintType;
        this.choices.addAll(choice.choices);
        this.choiceKey = choice.choiceKey;
        this.keyChoices = choice.keyChoices;
        this.sortData = choice.sortData;
        this.specialEnabled = choice.specialEnabled;
        this.specialCanBeEmpty = choice.specialCanBeEmpty;
        this.specialText = choice.specialText;
        this.specialHint = choice.specialHint;
        this.manaColorChoice = choice.manaColorChoice;
    }

    @Override
    public boolean isChosen() {
        return this.chosenNormal || this.chosenSpecial;
    }

    @Override
    public boolean isChosenSpecial() {
        return this.chosenSpecial;
    }

    @Override
    public void clearChoice() {
        this.choice = null;
        this.choiceKey = null;
        this.chosenNormal = false;
        this.chosenSpecial = false;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getSubMessage() {
        return this.subMessage;
    }

    @Override
    public void setSubMessage(String subMessage) {
        this.subMessage = subMessage;
    }

    @Override
    public Set<String> getChoices() {
        return this.choices;
    }

    @Override
    public void setChoices(Set<String> choices) {
        CardUtil.checkSetParamForSerializationCompatibility(choices);
        this.choices = choices;
        this.protectFromEmptyChoices();
    }

    @Override
    public String getChoice() {
        return this.choice;
    }

    @Override
    public void setChoice(String choice, boolean isSpecial) {
        if (this.choices.contains(choice)) {
            this.choice = choice;
            this.chosenNormal = true;
            this.chosenSpecial = isSpecial;
        }
        if (isSpecial && this.specialCanBeEmpty && (choice == null || choice.isEmpty())) {
            this.clearChoice();
            this.chosenNormal = false;
            this.chosenSpecial = true;
        }
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public ChoiceImpl copy() {
        return new ChoiceImpl(this);
    }

    @Override
    public Map<String, String> getKeyChoices() {
        return this.keyChoices;
    }

    @Override
    public void setKeyChoices(Map<String, String> choices) {
        this.keyChoices = choices;
        this.protectFromEmptyChoices();
    }

    @Override
    public String getChoiceKey() {
        return this.choiceKey;
    }

    @Override
    public String getChoiceValue() {
        if (this.keyChoices != null && this.keyChoices.containsKey(this.choiceKey)) {
            return this.keyChoices.get(this.choiceKey);
        }
        return null;
    }

    @Override
    public void setChoiceByKey(String choiceKey, boolean isSpecial) {
        String choiceToSet = this.keyChoices.get(choiceKey);
        if (choiceToSet != null) {
            this.choice = choiceToSet;
            this.choiceKey = choiceKey;
            this.chosenNormal = true;
            this.chosenSpecial = isSpecial;
        }
        if (isSpecial && this.specialCanBeEmpty && (choiceKey == null || choiceKey.isEmpty())) {
            this.clearChoice();
            this.chosenNormal = false;
            this.chosenSpecial = true;
        }
    }

    @Override
    public boolean isKeyChoice() {
        return !this.keyChoices.isEmpty();
    }

    @Override
    public boolean isSearchEnabled() {
        return this.searchEnabled;
    }

    @Override
    public void setSearchEnabled(boolean isEnabled) {
        this.searchEnabled = isEnabled;
    }

    @Override
    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    @Override
    public String getSearchText() {
        return this.searchText;
    }

    @Override
    public boolean isSortEnabled() {
        return this.sortData != null && !this.sortData.isEmpty();
    }

    @Override
    public void setSortData(Map<String, Integer> sortData) {
        this.sortData = sortData;
    }

    @Override
    public Map<String, Integer> getSortData() {
        return this.sortData;
    }

    @Override
    public Map<String, List<String>> getHintData() {
        return this.hintData;
    }

    @Override
    public Choice withItem(String key, String value, Integer sort, ChoiceHintType hintType, String hintValue) {
        this.keyChoices.put(key, value);
        if (sort != null) {
            this.sortData.put(key, sort);
        }
        if (hintType != null) {
            this.hintData.put(key, Arrays.asList(hintType.toString(), hintValue));
        }
        return this;
    }

    @Override
    public void setHintData(Map<String, List<String>> hintData) {
        hintData.forEach((key, info) -> {
            try {
                ChoiceHintType hintType = ChoiceHintType.valueOf((String)info.get(0));
                if (hintType == ChoiceHintType.GAME_OBJECT) {
                    UUID uUID = UUID.fromString((String)info.get(1));
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Wrong code usage: hints info must contains valid data, but found - " + info);
            }
        });
        this.hintData = hintData;
    }

    @Override
    public void setRandomChoice() {
        if (this.isKeyChoice()) {
            String[] vals = this.getKeyChoices().keySet().toArray(new String[0]);
            if (vals.length > 0) {
                int choiceNum = RandomUtil.nextInt(vals.length);
                this.setChoiceByKey(vals[choiceNum], false);
            }
        } else {
            String[] vals = this.getChoices().toArray(new String[0]);
            if (vals.length > 0) {
                int choiceNum = RandomUtil.nextInt(vals.length);
                this.setChoice(vals[choiceNum], false);
            }
        }
    }

    @Override
    public boolean setChoiceByAnswers(List<String> answers, boolean removeSelectAnswerFromList) {
        if (this.isKeyChoice()) {
            for (String needChoice : answers) {
                for (Map.Entry<String, String> currentChoice : this.getKeyChoices().entrySet()) {
                    if (!currentChoice.getKey().equals(needChoice)) continue;
                    if (removeSelectAnswerFromList) {
                        this.setChoiceByKey(needChoice, false);
                        answers.remove(needChoice);
                    }
                    return true;
                }
            }
            for (String needChoice : answers) {
                for (Map.Entry<String, String> currentChoice : this.getKeyChoices().entrySet()) {
                    String choiceValue = currentChoice.getValue();
                    String cleanedChoiceValue = choiceValue.replaceAll("<[^<>]*>", "");
                    if (!choiceValue.startsWith(needChoice) && !cleanedChoiceValue.startsWith(needChoice)) continue;
                    if (removeSelectAnswerFromList) {
                        this.setChoiceByKey(currentChoice.getKey(), false);
                        answers.remove(needChoice);
                    }
                    return true;
                }
            }
        } else {
            for (String needChoice : answers) {
                for (String currentChoice : this.getChoices()) {
                    String cleanedChoiceValue = currentChoice.replaceAll("<[^<>]*>", "");
                    if (!currentChoice.equals(needChoice) && !cleanedChoiceValue.equals(needChoice)) continue;
                    if (removeSelectAnswerFromList) {
                        this.setChoice(needChoice, false);
                        answers.remove(needChoice);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void setSpecial(boolean enabled, boolean canBeEmpty, String text, String hint) {
        this.specialEnabled = enabled;
        this.specialCanBeEmpty = canBeEmpty;
        this.specialText = text;
        this.specialHint = hint;
    }

    @Override
    public boolean isSpecialEnabled() {
        return this.specialEnabled;
    }

    @Override
    public boolean isSpecialCanBeEmpty() {
        return this.specialCanBeEmpty;
    }

    @Override
    public String getSpecialText() {
        return this.specialText;
    }

    @Override
    public String getSpecialHint() {
        return this.specialHint;
    }

    @Override
    public ChoiceHintType getHintType() {
        return this.hintType;
    }

    @Override
    public boolean isManaColorChoice() {
        return this.manaColorChoice;
    }

    @Override
    public ChoiceImpl setManaColorChoice(boolean manaColorChoice) {
        this.manaColorChoice = manaColorChoice;
        return this;
    }

    private void protectFromEmptyChoices() {
        if (!this.required) {
            return;
        }
        if (this.specialEnabled && this.specialCanBeEmpty) {
            return;
        }
        if (this.choices.isEmpty() && this.keyChoices.isEmpty()) {
            this.required = false;
            logger.error((Object)("Empty choice dialog in " + this.getClass().getCanonicalName()), new Throwable());
        }
    }

    @Override
    public void onChooseStart(Game game, UUID choosingPlayerId) {
    }

    @Override
    public void onChooseEnd(Game game, UUID choosingPlayerId, String choiceResult) {
    }
}

