/*
 * Decompiled with CFR 0.152.
 */
package mage.collectors;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import mage.collectors.DataCollector;
import mage.collectors.services.PrintGameLogsDataCollector;
import mage.collectors.services.SaveGameHistoryDataCollector;
import mage.game.Game;
import mage.game.Table;
import mage.players.Player;
import org.apache.log4j.Logger;

public final class DataCollectorServices
implements DataCollector {
    private static final String COMMAND_LINE_DATA_COLLECTORS_PREFIX = "xmage.dataCollectors.";
    private static final Logger logger = Logger.getLogger(DataCollectorServices.class);
    private static DataCollectorServices instance = null;
    Set<DataCollector> allServices = new LinkedHashSet<DataCollector>();
    Set<DataCollector> activeServices = new LinkedHashSet<DataCollector>();

    public static DataCollectorServices getInstance() {
        if (instance == null) {
            instance = new DataCollectorServices();
        }
        return instance;
    }

    public static void init(boolean enablePrintGameLogs, boolean enableSaveGameHistory) {
        if (instance != null) {
            return;
        }
        DataCollectorServices.getInstance().allServices.add(new PrintGameLogsDataCollector());
        DataCollectorServices.getInstance().allServices.add(new SaveGameHistoryDataCollector());
        logger.info((Object)String.format("Data collectors: found %d services", DataCollectorServices.getInstance().allServices.size()));
        DataCollectorServices.getInstance().allServices.forEach(service -> {
            boolean isDefault = false;
            isDefault |= enablePrintGameLogs && service.getServiceCode().equals("printGameLogs");
            boolean isEnable = DataCollectorServices.isServiceEnable(service.getServiceCode(), isDefault |= enableSaveGameHistory && service.getServiceCode().equals("saveGameHistory"));
            if (isEnable) {
                DataCollectorServices.getInstance().activeServices.add((DataCollector)service);
            }
            String info = isEnable ? String.format(" (%s)", service.getInitInfo()) : "";
            logger.info((Object)String.format("Data collectors: %s - %s%s", service.getServiceCode(), isEnable ? "enabled" : "disabled", info));
        });
    }

    private static boolean isServiceEnable(String dataCollectorCode, boolean isEnableByDefault) {
        String needCommand = COMMAND_LINE_DATA_COLLECTORS_PREFIX + dataCollectorCode;
        boolean isEnable = System.getProperty(needCommand) != null ? System.getProperty(needCommand, "false").equals("true") : isEnableByDefault;
        return isEnable;
    }

    @Override
    public String getServiceCode() {
        throw new IllegalStateException("Wrong code usage. Use it by static methods only");
    }

    @Override
    public String getInitInfo() {
        throw new IllegalStateException("Wrong code usage. Use it by static methods only");
    }

    @Override
    public void onServerStart() {
        this.activeServices.forEach(DataCollector::onServerStart);
    }

    @Override
    public void onTableStart(Table table) {
        this.activeServices.forEach(c -> c.onTableStart(table));
    }

    @Override
    public void onTableEnd(Table table) {
        this.activeServices.forEach(c -> c.onTableEnd(table));
    }

    @Override
    public void onGameStart(Game game) {
        if (game.isSimulation()) {
            return;
        }
        this.activeServices.forEach(c -> c.onGameStart(game));
    }

    @Override
    public void onGameLog(Game game, String message) {
        if (game.isSimulation()) {
            return;
        }
        this.activeServices.forEach(c -> c.onGameLog(game, message));
    }

    @Override
    public void onGameEnd(Game game) {
        if (game.isSimulation()) {
            return;
        }
        this.activeServices.forEach(c -> c.onGameEnd(game));
    }

    @Override
    public void onChatRoom(UUID roomId, String userName, String message) {
        this.activeServices.forEach(c -> c.onChatRoom(roomId, userName, message));
    }

    @Override
    public void onChatTourney(UUID tourneyId, String userName, String message) {
        this.activeServices.forEach(c -> c.onChatTourney(tourneyId, userName, message));
    }

    @Override
    public void onChatTable(UUID tableId, String userName, String message) {
        this.activeServices.forEach(c -> c.onChatTable(tableId, userName, message));
    }

    @Override
    public void onChatGame(UUID gameId, String userName, String message) {
        this.activeServices.forEach(c -> c.onChatGame(gameId, userName, message));
    }

    @Override
    public void onTestsChoiceUse(Game game, Player player, String usingChoice, String reason) {
        if (game.isSimulation()) {
            return;
        }
        this.activeServices.forEach(c -> c.onTestsChoiceUse(game, player, usingChoice, reason));
    }

    @Override
    public void onTestsTargetUse(Game game, Player player, String usingTarget, String reason) {
        if (game.isSimulation()) {
            return;
        }
        this.activeServices.forEach(c -> c.onTestsTargetUse(game, player, usingTarget, reason));
    }

    @Override
    public void onTestsStackPush(Game game) {
        if (game.isSimulation()) {
            return;
        }
        this.activeServices.forEach(c -> c.onTestsStackPush(game));
    }

    @Override
    public void onTestsStackResolve(Game game) {
        if (game.isSimulation()) {
            return;
        }
        this.activeServices.forEach(c -> c.onTestsStackResolve(game));
    }
}

