/*
 * Decompiled with CFR 0.152.
 */
package mage.collectors.services;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import mage.cards.decks.DeckFormats;
import mage.collectors.services.EmptyDataCollector;
import mage.constants.TableState;
import mage.game.Game;
import mage.game.Table;
import mage.game.match.MatchPlayer;
import mage.players.Player;
import mage.util.CardUtil;
import org.apache.log4j.Logger;
import org.jsoup.Jsoup;

public class SaveGameHistoryDataCollector
extends EmptyDataCollector {
    private static final Logger logger = Logger.getLogger(SaveGameHistoryDataCollector.class);
    public static final String SERVICE_CODE = "saveGameHistory";
    private static final String DIR_NAME_ROOT = "gamesHistory";
    private static final SimpleDateFormat DIR_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final String DIR_NAME_TABLES_ACTIVE = "tables_active";
    private static final String DIR_NAME_TABLES_DONE = "tables_done";
    private static final String DIR_NAME_GAMES_ACTIVE = "games_active";
    private static final String DIR_NAME_GAMES_DONE = "games_done";
    private static final String TABLE_LOGS_FILE_NAME = "table_logs.txt";
    private static final String TABLE_CHAT_FILE_NAME = "table_chat.txt";
    private static final String DECK_FILE_NAME_FORMAT = "deck_player_%d.dck";
    private static final String GAME_LOGS_FILE_NAME = "game_logs.html";
    private static final String GAME_CHAT_FILE_NAME = "game_chat.txt";
    private static final UUID NO_TABLE_ID = UUID.randomUUID();
    private static final String NO_TABLE_NAME = "SINGLE";
    boolean enabled;
    Map<UUID, String> tableDirs = new ConcurrentHashMap<UUID, String>();
    Map<UUID, String> gameDirs = new ConcurrentHashMap<UUID, String>();
    ReentrantLock writeLock = new ReentrantLock();

    public SaveGameHistoryDataCollector() {
        Path root = Paths.get(DIR_NAME_ROOT, new String[0]);
        if (!Files.exists(root, new LinkOption[0])) {
            try {
                Files.createDirectories(root, new FileAttribute[0]);
            }
            catch (IOException e) {
                logger.error((Object)("Can't create root dir, games history data collector will be disabled - " + e), (Throwable)e);
                this.enabled = false;
                return;
            }
        }
        this.enabled = true;
    }

    @Override
    public String getServiceCode() {
        return SERVICE_CODE;
    }

    @Override
    public String getInitInfo() {
        return "save all game history to " + Paths.get(DIR_NAME_ROOT, DIR_DATE_FORMAT.format(new Date())).toAbsolutePath();
    }

    @Override
    public void onTableStart(Table table) {
        if (!this.enabled) {
            return;
        }
        this.writeToTableLogsFile(table, new Date() + " [START] " + table.getId() + ", " + table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTableEnd(Table table) {
        if (!this.enabled) {
            return;
        }
        this.writeToTableLogsFile(table, new Date() + " [END] " + table.getId() + ", " + table);
        this.writeLock.lock();
        try {
            String oldFolder = this.getOrCreateTableDir(table.getId(), table.getParentTableId(), table.getTableIndex(), false);
            if (oldFolder.contains(DIR_NAME_TABLES_ACTIVE)) {
                String newFolder = oldFolder.replace(DIR_NAME_TABLES_ACTIVE, DIR_NAME_TABLES_DONE);
                Files.createDirectories(Paths.get(newFolder, new String[0]), new FileAttribute[0]);
                Files.move(Paths.get(oldFolder, new String[0]), Paths.get(newFolder, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                this.tableDirs.put(table.getId(), newFolder);
                this.gameDirs.replaceAll((gameId, gameFolder) -> gameFolder.startsWith(oldFolder) ? gameFolder.replace(oldFolder, newFolder) : gameFolder);
                this.innerDirDeleteEmptyParent(oldFolder);
            }
        }
        catch (IOException e) {
            logger.error((Object)("Can't move table files to done folder: " + e), (Throwable)e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onGameStart(Game game) {
        if (!this.enabled) {
            return;
        }
        this.writeToGameLogsFile(game, new Date() + " [START] " + game.getId() + ", " + game);
        this.writeLock.lock();
        try {
            String gameDir = this.getOrCreateGameDir(game, this.isActive(game));
            if (gameDir.isEmpty()) {
                return;
            }
            int playerNum = 0;
            for (Player player : game.getPlayers().values()) {
                ++playerNum;
                MatchPlayer matchPlayer = player.getMatchPlayer();
                if (matchPlayer == null || matchPlayer.getDeck() == null) continue;
                String deckFile = Paths.get(gameDir, String.format(DECK_FILE_NAME_FORMAT, playerNum)).toString();
                DeckFormats.XMAGE.getExporter().writeDeck(deckFile, matchPlayer.getDeckForViewer().prepareCardsOnlyDeck());
            }
        }
        catch (IOException e) {
            logger.error((Object)("Can't write deck file for game " + game.getId() + ": " + e), (Throwable)e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void onGameLog(Game game, String message) {
        if (!this.enabled) {
            return;
        }
        this.writeToGameLogsFile(game, new Date() + " [LOG] " + CardUtil.getTurnInfo(game) + ": " + message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onGameEnd(Game game) {
        if (!this.enabled) {
            return;
        }
        this.writeToGameLogsFile(game, new Date() + " [END] " + game.getId() + ", " + game);
        this.writeLock.lock();
        try {
            String oldFolder = this.getOrCreateGameDir(game, false);
            if (oldFolder.contains(DIR_NAME_GAMES_ACTIVE)) {
                String newFolder = oldFolder.replace(DIR_NAME_GAMES_ACTIVE, DIR_NAME_GAMES_DONE);
                Files.createDirectories(Paths.get(newFolder, new String[0]), new FileAttribute[0]);
                Files.move(Paths.get(oldFolder, new String[0]), Paths.get(newFolder, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                this.gameDirs.replaceAll((gameId, gameFolder) -> gameFolder.startsWith(oldFolder) ? gameFolder.replace(oldFolder, newFolder) : gameFolder);
                this.innerDirDeleteEmptyParent(oldFolder);
            }
        }
        catch (IOException e) {
            logger.error((Object)("Can't move game files to done folder: " + e), (Throwable)e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void onChatTourney(UUID tourneyId, String userName, String message) {
    }

    @Override
    public void onChatTable(UUID tableId, String userName, String message) {
        if (!this.enabled) {
            return;
        }
        String needMessage = Jsoup.parse((String)message).text();
        this.writeToTableChatFile(tableId, new Date() + " [CHAT] " + (userName == null ? "system" : userName) + ": " + needMessage);
    }

    @Override
    public void onChatGame(UUID gameId, String userName, String message) {
        if (!this.enabled) {
            return;
        }
        String needMessage = Jsoup.parse((String)message).text();
        this.writeToGameChatFile(gameId, new Date() + " [CHAT] " + (userName == null ? "system" : userName) + ": " + needMessage);
    }

    private String getOrCreateTableDir(UUID tableId) {
        return this.tableDirs.getOrDefault(tableId, "");
    }

    private String getOrCreateTableDir(UUID tableId, UUID parentTableId, Integer tableIndex, boolean isActive) {
        String needName;
        UUID needId;
        if (tableId == null) {
            needId = NO_TABLE_ID;
            needName = String.format("table %s", NO_TABLE_NAME);
        } else {
            needId = tableId;
            needName = parentTableId == null ? String.format("table %s - %s", tableIndex, tableId) : String.format("table %s - %s_%s", tableIndex, parentTableId, tableId);
        }
        String needDate = DIR_DATE_FORMAT.format(new Date());
        String needStatus = isActive ? DIR_NAME_TABLES_ACTIVE : DIR_NAME_TABLES_DONE;
        String tableDir = Paths.get(DIR_NAME_ROOT, needDate, needStatus, needName).toString();
        return this.tableDirs.computeIfAbsent(needId, x -> this.innerDirCreate(tableDir));
    }

    private String getOrCreateGameDir(UUID gameId) {
        return this.gameDirs.getOrDefault(gameId, "");
    }

    private String getOrCreateGameDir(Game game, boolean isActive) {
        AtomicBoolean isNewDir = new AtomicBoolean(false);
        String res = this.gameDirs.computeIfAbsent(game.getId(), x -> {
            isNewDir.set(true);
            String tableDir = this.getOrCreateTableDir(game.getTableId(), null, 0, true);
            if (tableDir.isEmpty()) {
                return "";
            }
            String needStatus = isActive ? DIR_NAME_GAMES_ACTIVE : DIR_NAME_GAMES_DONE;
            String needName = String.format("game %s - %s", game.getGameIndex(), game.getId());
            String gameDir = Paths.get(tableDir, needStatus, needName).toString();
            return this.innerDirCreate(gameDir);
        });
        if (isNewDir.get()) {
            this.writeToGameLogsFile(game, "<body style=\"background: #862c10\">");
        }
        return res;
    }

    private String innerDirCreate(String destFileOrDir) {
        Path dir = Paths.get(destFileOrDir, new String[0]);
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException ignore) {
                return "";
            }
        }
        return dir.toString();
    }

    private void innerDirDeleteEmptyParent(String dir) throws IOException {
        Path parentPath = Paths.get(dir, new String[0]).getParent();
        if (Files.exists(parentPath, new LinkOption[0]) && Files.isDirectory(parentPath, new LinkOption[0])) {
            try (Stream<Path> entries = Files.list(parentPath);){
                if (!entries.findAny().isPresent()) {
                    Files.delete(parentPath);
                }
            }
        }
    }

    private void writeToTableLogsFile(Table table, String data) {
        String tableDir = this.getOrCreateTableDir(table.getId(), table.getParentTableId(), table.getTableIndex(), this.isActive(table));
        if (tableDir.isEmpty()) {
            return;
        }
        this.writeToFile(Paths.get(tableDir, TABLE_LOGS_FILE_NAME).toString(), data, "\n");
    }

    private void writeToTableChatFile(UUID tableId, String data) {
        String gameDir = this.getOrCreateTableDir(tableId);
        if (gameDir.isEmpty()) {
            return;
        }
        this.writeToFile(Paths.get(gameDir, TABLE_CHAT_FILE_NAME).toString(), data, "\n");
    }

    private void writeToGameLogsFile(Game game, String data) {
        String gameDir = this.getOrCreateGameDir(game, this.isActive(game));
        if (gameDir.isEmpty()) {
            return;
        }
        this.writeToFile(Paths.get(gameDir, GAME_LOGS_FILE_NAME).toString(), data, "\n<br>\n");
    }

    private void writeToGameChatFile(UUID gameId, String data) {
        String gameDir = this.getOrCreateGameDir(gameId);
        if (gameDir.isEmpty()) {
            return;
        }
        this.writeToFile(Paths.get(gameDir, GAME_CHAT_FILE_NAME).toString(), data, "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(String destFile, String data, String newLine) {
        this.writeLock.lock();
        try {
            try {
                String newData = newLine + data;
                Files.write(Paths.get(destFile, new String[0]), newData.getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private boolean isActive(Table table) {
        return !TableState.FINISHED.equals((Object)table.getState());
    }

    private boolean isActive(Game game) {
        return game.getState() == null || !game.getState().isGameOver();
    }
}

