/*
 * Decompiled with CFR 0.152.
 */
package mage.constants;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mage.Mana;
import mage.choices.Choice;
import mage.choices.ChoiceColor;

public enum ManaType {
    BLACK("black"),
    BLUE("blue"),
    GREEN("green"),
    RED("red"),
    WHITE("white"),
    GENERIC("generic"),
    COLORLESS("colorless");

    private final String text;

    private ManaType(String text) {
        this.text = text;
    }

    public String toString() {
        return this.text;
    }

    public static Choice getChoiceOfManaTypes(Collection<ManaType> types, boolean onlyColors) {
        ChoiceColor choice = new ChoiceColor(true);
        choice.getChoices().clear();
        choice.setMessage("Pick a mana " + (onlyColors ? "color" : "type"));
        if (types.contains((Object)BLACK)) {
            choice.getChoices().add("Black");
        }
        if (types.contains((Object)RED)) {
            choice.getChoices().add("Red");
        }
        if (types.contains((Object)BLUE)) {
            choice.getChoices().add("Blue");
        }
        if (types.contains((Object)GREEN)) {
            choice.getChoices().add("Green");
        }
        if (types.contains((Object)WHITE)) {
            choice.getChoices().add("White");
        }
        if (types.contains((Object)COLORLESS) && !onlyColors) {
            choice.getChoices().add("Colorless");
        }
        return choice;
    }

    public static List<Mana> getManaListFromManaTypes(Set<ManaType> manaTypes, boolean onlyColors) {
        ArrayList<Mana> netManas = new ArrayList<Mana>();
        if (manaTypes.size() == 5 && !manaTypes.contains((Object)COLORLESS) || manaTypes.size() == 6) {
            netManas.add(Mana.AnyMana(1));
        } else {
            if (manaTypes.contains((Object)BLACK)) {
                netManas.add(Mana.BlackMana(1));
            }
            if (manaTypes.contains((Object)RED)) {
                netManas.add(Mana.RedMana(1));
            }
            if (manaTypes.contains((Object)BLUE)) {
                netManas.add(Mana.BlueMana(1));
            }
            if (manaTypes.contains((Object)GREEN)) {
                netManas.add(Mana.GreenMana(1));
            }
            if (manaTypes.contains((Object)WHITE)) {
                netManas.add(Mana.WhiteMana(1));
            }
        }
        if (!onlyColors && manaTypes.contains((Object)COLORLESS)) {
            netManas.add(Mana.ColorlessMana(1));
        }
        return netManas;
    }

    public static Set<ManaType> getManaTypesFromManaList(Mana mana) {
        EnumSet<ManaType> manaTypes = EnumSet.noneOf(ManaType.class);
        if (mana.getAny() > 0) {
            manaTypes.add(BLACK);
            manaTypes.add(BLUE);
            manaTypes.add(GREEN);
            manaTypes.add(WHITE);
            manaTypes.add(RED);
        } else {
            if (mana.getBlack() > 0) {
                manaTypes.add(BLACK);
            }
            if (mana.getBlue() > 0) {
                manaTypes.add(BLUE);
            }
            if (mana.getGreen() > 0) {
                manaTypes.add(GREEN);
            }
            if (mana.getWhite() > 0) {
                manaTypes.add(WHITE);
            }
            if (mana.getRed() > 0) {
                manaTypes.add(RED);
            }
        }
        if (mana.getColorless() > 0) {
            manaTypes.add(COLORLESS);
        }
        return manaTypes;
    }

    public static ManaType findByName(String name) {
        switch (name) {
            case "Black": {
                return BLACK;
            }
            case "Blue": {
                return BLUE;
            }
            case "Red": {
                return RED;
            }
            case "Green": {
                return GREEN;
            }
            case "White": {
                return WHITE;
            }
            case "Colorless": {
                return COLORLESS;
            }
        }
        return null;
    }

    public static Set<ManaType> getManaTypesFromManaList(List<Mana> manaList) {
        HashSet<ManaType> manaTypes = new HashSet<ManaType>();
        for (Mana mana : manaList) {
            manaTypes.addAll(ManaType.getManaTypesFromManaList(mana));
        }
        return manaTypes;
    }

    public static Set<ManaType> getTrueManaTypes() {
        return EnumSet.of(BLACK, new ManaType[]{BLUE, GREEN, RED, WHITE, COLORLESS});
    }
}

