/*
 * Decompiled with CFR 0.152.
 */
package mage.constants;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import mage.util.CardUtil;
import mage.util.MultiAmountMessage;

public class MultiAmountType {
    public static final MultiAmountType MANA = new MultiAmountType("Add mana", "Distribute mana among colors");
    public static final MultiAmountType DAMAGE = new MultiAmountType("Assign damage", "Assign damage among targets");
    public static final MultiAmountType P1P1 = new MultiAmountType("Add +1/+1 counters", "Distribute +1/+1 counters among creatures");
    public static final MultiAmountType COUNTERS = new MultiAmountType("Choose counters", "Move counters");
    public static final MultiAmountType REMOVE_COUNTERS = new MultiAmountType("Choose counters", "Remove counters");
    public static final MultiAmountType CHEAT_LANDS = new MultiAmountType("Choose lands", "Add lands to your battlefield", true);
    private final String title;
    private final String header;
    private final boolean canCancel;

    public MultiAmountType(String title, String header) {
        this(title, header, false);
    }

    public MultiAmountType(String title, String header, boolean canCancel) {
        this.title = title;
        this.header = header;
        this.canCancel = canCancel;
    }

    public String getTitle() {
        return this.title;
    }

    public String getHeader() {
        return this.header;
    }

    public boolean isCanCancel() {
        return this.canCancel;
    }

    public static List<Integer> prepareDefaultValues(List<MultiAmountMessage> constraints, int min, int max) {
        List<Integer> res = constraints.stream().map(m -> m.defaultValue > Integer.MIN_VALUE ? m.defaultValue : Math.min(0, max)).collect(Collectors.toList());
        if (res.isEmpty()) {
            return res;
        }
        int total = res.stream().mapToInt(x -> x).sum();
        if (min > 0 && total < min) {
            int left = min - total;
            for (int i = 0; i < res.size(); ++i) {
                if (constraints.get((int)i).max == Integer.MAX_VALUE || constraints.get((int)i).max - res.get(i) > left) {
                    res.set(i, res.get(i) + left);
                    break;
                }
                int add = constraints.get((int)i).max - res.get(i);
                res.set(i, constraints.get((int)i).max);
                left -= add;
            }
        }
        return res;
    }

    public static List<Integer> prepareMaxValues(List<MultiAmountMessage> constraints, int min, int max) {
        if (constraints.isEmpty()) {
            return new ArrayList<Integer>();
        }
        int default_val = max / constraints.size();
        List<Integer> res = constraints.stream().map(m -> m.min > Integer.MIN_VALUE ? m.min : (default_val < m.max ? default_val : m.max)).collect(Collectors.toList());
        int total = res.stream().mapToInt(x -> x).sum();
        while (total < max) {
            int i;
            int addable = Integer.MIN_VALUE;
            ArrayList<Integer> consider = new ArrayList<Integer>();
            for (int i2 = 0; i2 < res.size(); ++i2) {
                if (constraints.get((int)i2).max == Integer.MAX_VALUE) {
                    consider.add(i2);
                    continue;
                }
                int diff = constraints.get((int)i2).max - res.get(i2);
                if (diff <= 0) continue;
                consider.add(i2);
                if (diff >= addable) continue;
                addable = diff;
            }
            if (consider.isEmpty()) break;
            if (addable > Integer.MIN_VALUE && total + addable * consider.size() < max) {
                Iterator i2 = consider.iterator();
                while (i2.hasNext()) {
                    i = (Integer)i2.next();
                    res.set(i, res.get(i) + addable);
                }
                total += addable * consider.size();
                continue;
            }
            addable = (max - total) / consider.size();
            int extras = (max - total) % consider.size();
            for (i = 0; i < consider.size(); ++i) {
                int idx = (Integer)consider.get(i);
                if (i < extras) {
                    res.set(idx, res.get(idx) + addable + 1);
                    continue;
                }
                res.set(idx, res.get(idx) + addable);
            }
            total = max;
        }
        return res;
    }

    public static boolean isGoodValues(List<Integer> values, List<MultiAmountMessage> constraints, int totalMin, int totalMax) {
        if (values.size() != constraints.size()) {
            return false;
        }
        int currentSum = 0;
        for (int i = 0; i < values.size(); ++i) {
            int value = values.get(i);
            if (value < constraints.get((int)i).min || value > constraints.get((int)i).max) {
                return false;
            }
            currentSum += value;
        }
        return currentSum >= totalMin && currentSum <= totalMax;
    }

    public static List<Integer> parseAnswer(String answerToParse, List<MultiAmountMessage> constraints, int min, int max, boolean returnDefaultOnError) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        String normalValue = answerToParse.trim();
        if (!normalValue.isEmpty()) {
            Arrays.stream(normalValue.split(" ")).forEach(valueStr -> res.add(CardUtil.parseIntWithDefault(valueStr, 0)));
        }
        if (returnDefaultOnError && !MultiAmountType.isGoodValues(res, constraints, min, max)) {
            return MultiAmountType.prepareDefaultValues(constraints, min, max);
        }
        return res;
    }
}

