/*
 * Decompiled with CFR 0.152.
 */
package mage.constants;

public enum SetType {
    EXPANSION("Expansion"),
    CORE("Core"),
    MAGIC_ONLINE("Magic Online"),
    MAGIC_ARENA("Magic Arena"),
    SUPPLEMENTAL("Supplemental"),
    SUPPLEMENTAL_STANDARD_LEGAL("Standard Legal Supplemental"),
    SUPPLEMENTAL_MODERN_LEGAL("Modern Legal Supplemental"),
    PROMOTIONAL("Promotional"),
    REMIX("Remix"),
    JOKE_SET("Joke Set"),
    CUSTOM_SET("Unofficial Set");

    private final String text;

    private SetType(String text) {
        this.text = text;
    }

    public String toString() {
        return this.text;
    }

    public boolean isCustomSet() {
        return this == CUSTOM_SET;
    }

    public boolean isJokeSet() {
        return this == JOKE_SET;
    }

    public boolean isEternalLegal() {
        return this != CUSTOM_SET && this != JOKE_SET && this != REMIX && this != MAGIC_ARENA;
    }

    public boolean isStandardLegal() {
        return this == CORE || this == EXPANSION || this == SUPPLEMENTAL_STANDARD_LEGAL;
    }

    public boolean isModernLegal() {
        return this.isStandardLegal() || this == SUPPLEMENTAL_MODERN_LEGAL;
    }

    public boolean isHistoricLegal() {
        return this.isStandardLegal() || this == MAGIC_ARENA;
    }
}

