/*
 * Decompiled with CFR 0.152.
 */
package mage.counters;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mage.counters.AbilityCounter;
import mage.counters.BoostCounter;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.util.Copyable;

public class Counters
extends HashMap<String, Counter>
implements Serializable,
Copyable<Counters> {
    public Counters(Counter ... counters) {
        for (Counter counter : counters) {
            this.addCounter(counter);
        }
    }

    protected Counters(Counters counters) {
        for (Map.Entry entry : counters.entrySet()) {
            this.put(entry.getKey(), ((Counter)entry.getValue()).copy());
        }
    }

    @Override
    public Counters copy() {
        return new Counters(this);
    }

    public Counters addCounter(Counter counter) {
        if (!this.containsKey(counter.name)) {
            this.put(counter.name, counter);
        } else {
            ((Counter)this.get(counter.name)).add(counter.getCount());
        }
        return this;
    }

    public boolean removeCounter(CounterType counterType, int amount) {
        return this.removeCounter(counterType.getName(), amount);
    }

    public boolean removeCounter(String name, int amount) {
        if (this.containsKey(name)) {
            ((Counter)this.get(name)).remove(amount);
            if (((Counter)this.get(name)).getCount() == 0) {
                this.remove(name);
            }
            return true;
        }
        return false;
    }

    public int getCount(String name) {
        if (this.containsKey(name)) {
            return ((Counter)this.get(name)).getCount();
        }
        return 0;
    }

    public boolean containsKey(CounterType counterType) {
        return this.getCount(counterType) > 0;
    }

    public int getTotalCount() {
        return this.values().stream().mapToInt(Counter::getCount).sum();
    }

    public int getCount(CounterType type) {
        if (this.containsKey(type.getName())) {
            return ((Counter)this.get(type.getName())).getCount();
        }
        return 0;
    }

    public List<BoostCounter> getBoostCounters() {
        return this.values().stream().filter(BoostCounter.class::isInstance).map(BoostCounter.class::cast).collect(Collectors.toList());
    }

    public List<AbilityCounter> getAbilityCounters() {
        return this.values().stream().filter(AbilityCounter.class::isInstance).map(AbilityCounter.class::cast).collect(Collectors.toList());
    }
}

