/*
 * Decompiled with CFR 0.152.
 */
package mage.designations;

import java.util.Objects;
import java.util.UUID;
import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.constants.Zone;
import mage.designations.InitiativeTakeEffect;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.events.DamagedBatchForOnePlayerEvent;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;

class InitiativeDamageTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<DamagedPlayerEvent> {
    InitiativeDamageTriggeredAbility() {
        super(Zone.ALL, new InitiativeTakeEffect());
    }

    private InitiativeDamageTriggeredAbility(InitiativeDamageTriggeredAbility ability) {
        super(ability);
    }

    @Override
    public InitiativeDamageTriggeredAbility copy() {
        return new InitiativeDamageTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_BATCH_FOR_ONE_PLAYER;
    }

    @Override
    public boolean checkEvent(DamagedPlayerEvent event, Game game) {
        if (!event.isCombatDamage() || !event.getTargetId().equals(game.getInitiativeId())) {
            return false;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
        return permanent != null && permanent.isCreature(game);
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        UUID playerId = this.getFilteredEvents((DamagedBatchForOnePlayerEvent)event, game).stream().map(GameEvent::getSourceId).map(game::getPermanent).filter(Objects::nonNull).map(Controllable::getControllerId).findFirst().orElse(null);
        if (playerId == null) {
            return false;
        }
        this.getEffects().setTargetPointer(new FixedTarget(playerId));
        return true;
    }

    @Override
    public String getRule() {
        return "Whenever one or more creatures a player controls deal combat damage to the player who has the initiative, the controller of those creatures takes the initiative.";
    }
}

