/*
 * Decompiled with CFR 0.152.
 */
package mage.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.filter.FilterObject;
import mage.filter.predicate.ObjectSourcePlayer;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.command.CommandObject;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;

public class FilterSource
extends FilterObject<MageObject> {
    protected final List<ObjectSourcePlayerPredicate<MageObject>> extraPredicates = new ArrayList<ObjectSourcePlayerPredicate<MageObject>>();

    public FilterSource() {
        super("source");
    }

    public FilterSource(String name) {
        super(name);
    }

    private FilterSource(FilterSource filter) {
        super(filter);
        this.extraPredicates.addAll(filter.extraPredicates);
    }

    @Override
    public FilterSource copy() {
        return new FilterSource(this);
    }

    public FilterSource add(ObjectSourcePlayerPredicate predicate) {
        if (this.isLockedFilter()) {
            throw new UnsupportedOperationException("You may not modify a locked filter");
        }
        Predicates.makeSurePredicateCompatibleWithFilter(predicate, Permanent.class, Card.class, StackObject.class, CommandObject.class);
        this.extraPredicates.add(predicate);
        return this;
    }

    @Override
    public boolean checkObjectClass(Object object) {
        return object instanceof Permanent || object instanceof Card || object instanceof StackObject || object instanceof CommandObject;
    }

    public boolean match(MageObject object, UUID sourceControllerId, Ability source, Game game) {
        if (!this.match(object, game)) {
            return false;
        }
        ObjectSourcePlayer<MageObject> osp = new ObjectSourcePlayer<MageObject>(object, sourceControllerId, source);
        return this.extraPredicates.stream().allMatch(p -> p.apply(osp, game));
    }

    @Override
    public List<Predicate> getExtraPredicates() {
        return new ArrayList<Predicate>(this.extraPredicates);
    }
}

