/*
 * Decompiled with CFR 0.152.
 */
package mage.filter.common;

import java.util.UUID;
import mage.MageItem;
import mage.abilities.Ability;
import mage.filter.FilterImpl;
import mage.filter.FilterInPlay;
import mage.filter.FilterPermanent;
import mage.filter.FilterPlayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

public class FilterPermanentOrPlayer
extends FilterImpl<MageItem>
implements FilterInPlay<MageItem> {
    protected final FilterPermanent permanentFilter;
    protected final FilterPlayer playerFilter;

    public FilterPermanentOrPlayer() {
        this("player or permanent");
    }

    public FilterPermanentOrPlayer(String name) {
        this(name, new FilterPermanent(), new FilterPlayer());
    }

    public FilterPermanentOrPlayer(String name, FilterPermanent permanentFilter, FilterPlayer playerFilter) {
        super(name);
        this.permanentFilter = permanentFilter;
        this.playerFilter = playerFilter;
    }

    protected FilterPermanentOrPlayer(FilterPermanentOrPlayer filter) {
        super(filter);
        this.permanentFilter = filter.permanentFilter.copy();
        this.playerFilter = filter.playerFilter.copy();
    }

    @Override
    public boolean checkObjectClass(Object object) {
        return true;
    }

    @Override
    public boolean match(MageItem o, Game game) {
        if (super.match(o, game)) {
            if (o instanceof Player) {
                return this.playerFilter.match((Player)o, game);
            }
            if (o instanceof Permanent) {
                return this.permanentFilter.match((Permanent)o, game);
            }
        }
        return false;
    }

    @Override
    public boolean match(MageItem o, UUID playerId, Ability source, Game game) {
        if (super.match(o, game)) {
            if (o instanceof Player) {
                return this.playerFilter.match((Player)o, playerId, source, game);
            }
            if (o instanceof Permanent) {
                return this.permanentFilter.match((Permanent)o, playerId, source, game);
            }
        }
        return false;
    }

    public FilterPermanent getPermanentFilter() {
        return this.permanentFilter;
    }

    public FilterPlayer getPlayerFilter() {
        return this.playerFilter;
    }

    @Override
    public FilterPermanentOrPlayer copy() {
        return new FilterPermanentOrPlayer(this);
    }
}

