/*
 * Decompiled with CFR 0.152.
 */
package mage.filter.predicate.mageobject;

import java.util.UUID;
import mage.MageItem;
import mage.MageObject;
import mage.MageObjectReference;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

public class MageObjectReferencePredicate
implements Predicate<MageItem> {
    private final MageObjectReference mor;

    public MageObjectReferencePredicate(UUID sourceId, Game game) {
        this(new MageObjectReference(sourceId, game));
    }

    public MageObjectReferencePredicate(MageObject mageObject, Game game) {
        this(new MageObjectReference(mageObject, game));
    }

    public MageObjectReferencePredicate(MageObjectReference mor) {
        this.mor = mor;
    }

    @Override
    public boolean apply(MageItem input, Game game) {
        if (input instanceof Player) {
            return this.mor.getSourceId().equals(input.getId());
        }
        return input instanceof MageObject && this.mor.refersTo((MageObject)input, game);
    }

    public String getName(Game game) {
        Player player;
        UUID id = null;
        String name = null;
        Permanent permanent = this.mor.getPermanent(game);
        if (permanent != null) {
            id = permanent.getId();
            name = permanent.getName();
        }
        if ((player = game.getPlayer(this.mor.getSourceId())) != null) {
            id = player.getId();
            name = player.getName();
        }
        if (id != null) {
            return String.format("%s [%s]", name, id);
        }
        return null;
    }

    public String toString() {
        return "MageObjectReference(" + this.mor.toString() + ')';
    }
}

