/*
 * Decompiled with CFR 0.152.
 */
package mage.filter.predicate.mageobject;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import mage.MageObject;
import mage.constants.CardType;
import mage.filter.predicate.Predicate;
import mage.game.Game;

public class SharesCardTypePredicate
implements Predicate<MageObject> {
    private final LinkedHashSet<CardType> cardTypes;

    public SharesCardTypePredicate(Collection<CardType> cardTypes) {
        this.cardTypes = new LinkedHashSet<CardType>(cardTypes);
    }

    @Override
    public boolean apply(MageObject input, Game game) {
        for (CardType type : input.getCardType(game)) {
            if (!this.cardTypes.contains((Object)type)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        Iterator it = this.cardTypes.iterator();
        switch (this.cardTypes.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return ((CardType)((Object)it.next())).toString().toLowerCase(Locale.ENGLISH);
            }
            case 2: {
                return ((CardType)((Object)it.next())).toString().toLowerCase(Locale.ENGLISH) + " or " + ((CardType)((Object)it.next())).toString().toLowerCase(Locale.ENGLISH);
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append(((CardType)((Object)it.next())).toString().toLowerCase(Locale.ENGLISH));
        while (it.hasNext()) {
            CardType type = (CardType)((Object)it.next());
            sb.append(", ");
            if (!it.hasNext()) {
                sb.append("or ");
            }
            sb.append(type.toString().toLowerCase(Locale.ENGLISH));
        }
        return sb.toString();
    }
}

