/*
 * Decompiled with CFR 0.152.
 */
package mage.game;

import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.common.CommanderChooseColorAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.common.InfoEffect;
import mage.abilities.effects.common.continuous.CommanderReplacementEffect;
import mage.abilities.effects.common.cost.CommanderCostModification;
import mage.abilities.keyword.CompanionAbility;
import mage.cards.Card;
import mage.choices.ChoiceColor;
import mage.constants.CommanderCardType;
import mage.constants.MultiplayerAttackOption;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.constants.RangeOfInfluence;
import mage.constants.Zone;
import mage.filter.FilterMana;
import mage.game.GameImpl;
import mage.game.mulligan.Mulligan;
import mage.game.turn.TurnMod;
import mage.players.Player;
import mage.watchers.common.CommanderInfoWatcher;

public abstract class GameCommanderImpl
extends GameImpl {
    protected boolean checkCommanderDamage = true;
    protected boolean alsoHand = true;
    protected boolean alsoLibrary = true;
    protected boolean startingPlayerSkipsDraw = true;

    public GameCommanderImpl(MultiplayerAttackOption attackOption, RangeOfInfluence range, Mulligan mulligan, int minimumDeckSize, int startLife, int startHandSize) {
        super(attackOption, range, mulligan, minimumDeckSize, startLife, startHandSize);
    }

    protected GameCommanderImpl(GameCommanderImpl game) {
        super(game);
        this.alsoHand = game.alsoHand;
        this.alsoLibrary = game.alsoLibrary;
        this.startingPlayerSkipsDraw = game.startingPlayerSkipsDraw;
        this.checkCommanderDamage = game.checkCommanderDamage;
    }

    private void handlePipers(Player player, Set<Card> commanders) {
        int piperCount = commanders.stream().filter(CommanderChooseColorAbility::checkCard).mapToInt(x -> 1).sum();
        if (piperCount < 1) {
            return;
        }
        FilterMana leftoverColors = new FilterMana();
        Stream.concat(player.getLibrary().getCards(this).stream(), player.getSideboard().getCards(this).stream()).map(Card::getColorIdentity).forEach(leftoverColors::addAll);
        FilterMana nonPiperIdentity = new FilterMana();
        commanders.stream().filter(card -> !CommanderChooseColorAbility.checkCard(card)).map(Card::getColorIdentity).forEach(nonPiperIdentity::addAll);
        leftoverColors.removeAll(nonPiperIdentity);
        if (piperCount < leftoverColors.getColorCount()) {
            throw new UnsupportedOperationException("This deck should not be legal, something went wrong");
        }
        ListIterator<ObjectColor> iterator = leftoverColors.getColors().listIterator();
        for (Card commander : commanders) {
            ObjectColor color;
            if (!CommanderChooseColorAbility.checkCard(commander)) continue;
            if (!iterator.hasNext()) {
                ChoiceColor choiceColor = new ChoiceColor(true, "Choose a color for " + commander.getName());
                player.choose(Outcome.Neutral, choiceColor, this);
                color = choiceColor.getColor();
            } else {
                color = (ObjectColor)iterator.next();
            }
            if (color == null) continue;
            commander.getColor().addColor(color);
        }
    }

    @Override
    protected void init(UUID choosingPlayerId) {
        for (UUID playerId : this.state.getPlayerList(this.startingPlayerId)) {
            Player player = this.getPlayer(playerId);
            if (player == null) continue;
            HashSet<Card> commanders = new HashSet<Card>();
            for (UUID cardId : player.getSideboard()) {
                Card card = this.getCard(cardId);
                if (card == null) continue;
                if (player.getSideboard().size() > 1) {
                    if (card.getAbilities(this).stream().anyMatch(CompanionAbility.class::isInstance)) continue;
                }
                commanders.add(card);
                this.addCommander(card, player);
            }
            this.handlePipers(player, commanders);
            for (UUID commanderId : this.getCommandersIds(player, CommanderCardType.ANY, false)) {
                Card commander = this.getCard(commanderId);
                if (commander == null) continue;
                this.initCommander(commander, player);
            }
        }
        super.init(choosingPlayerId);
        if (this.startingPlayerSkipsDraw) {
            this.state.getTurnMods().add(new TurnMod(this.startingPlayerId).withSkipStep(PhaseStep.DRAW));
        }
    }

    public void initCommander(Card commander, Player player) {
        if (!Zone.EXILED.equals((Object)this.getState().getZone(commander.getId()))) {
            commander.moveToZone(Zone.COMMAND, null, this, true);
        }
        commander.getAbilities().setControllerId(player.getId());
        SimpleStaticAbility ability = new SimpleStaticAbility(Zone.COMMAND, new InfoEffect("Commander effects"));
        this.initCommanderEffects(commander, player, ability);
        CommanderInfoWatcher watcher = this.initCommanderWatcher(commander, this.checkCommanderDamage);
        this.getState().addWatcher(watcher);
        watcher.addCardInfoToCommander(this);
        this.getState().addAbility((Ability)ability, null);
    }

    public CommanderInfoWatcher initCommanderWatcher(Card commander, boolean checkCommanderDamage) {
        return new CommanderInfoWatcher("Commander", commander.getId(), checkCommanderDamage);
    }

    public void initCommanderEffects(Card commander, Player player, Ability commanderAbility) {
        commanderAbility.addEffect(new CommanderReplacementEffect(commander.getId(), this.alsoHand, this.alsoLibrary, false, "Commander"));
        commanderAbility.addEffect(new CommanderCostModification(commander));
    }

    @Override
    public void mulligan(UUID playerId) {
        super.mulligan(playerId);
    }

    @Override
    public void endMulligan(UUID playerId) {
        super.endMulligan(playerId);
    }

    @Override
    protected boolean checkStateBasedActions() {
        for (Player player : this.getPlayers().values()) {
            if (!player.isInGame()) continue;
            for (UUID commanderId : this.getCommandersIds(player, CommanderCardType.COMMANDER_OR_OATHBREAKER, false)) {
                CommanderInfoWatcher damageWatcher = this.getState().getWatcher(CommanderInfoWatcher.class, commanderId);
                if (damageWatcher == null) continue;
                for (Map.Entry<UUID, Integer> entrySet : damageWatcher.getDamageToPlayer().entrySet()) {
                    Player opponent;
                    if (entrySet.getValue() <= 20 || (opponent = this.getPlayer(entrySet.getKey())) == null || opponent.hasLost()) continue;
                    opponent.lost(this);
                }
            }
        }
        return super.checkStateBasedActions();
    }

    public void setAlsoHand(boolean alsoHand) {
        this.alsoHand = alsoHand;
    }

    public void setAlsoLibrary(boolean alsoLibrary) {
        this.alsoLibrary = alsoLibrary;
    }

    public boolean isCheckCommanderDamage() {
        return this.checkCommanderDamage;
    }

    public void setCheckCommanderDamage(boolean checkCommanderDamage) {
        this.checkCommanderDamage = checkCommanderDamage;
    }

    public void addCommander(Card card, Player player) {
        player.addCommanderId(card.getId());
    }
}

