/*
 * Decompiled with CFR 0.152.
 */
package mage.game;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import mage.cards.decks.DeckCardInfo;
import mage.constants.PhaseStep;
import mage.util.Copyable;

public class GameOptions
implements Serializable,
Copyable<GameOptions> {
    private static final GameOptions deinstance = new GameOptions();
    public boolean testMode = false;
    public Integer stopOnTurn = null;
    public PhaseStep stopAtStep = PhaseStep.UNTAP;
    public boolean skipInitShuffling = false;
    public boolean rollbackTurnsAllowed = true;
    public Set<String> bannedUsers = new HashSet<String>();
    public Collection<DeckCardInfo> perPlayerEmblemCards = new HashSet<DeckCardInfo>();
    public Collection<DeckCardInfo> globalEmblemCards = new HashSet<DeckCardInfo>();
    public boolean planeChase = false;
    public static final int PLANECHASE_PLANAR_DIE_CHAOS_SIDES = 2;
    public static final int PLANECHASE_PLANAR_DIE_PLANAR_SIDES = 2;
    public static final int PLANECHASE_PLANAR_DIE_TOTAL_SIDES = 9;

    public static GameOptions getDefault() {
        return deinstance;
    }

    public GameOptions() {
    }

    private GameOptions(GameOptions options) {
        this.testMode = options.testMode;
        this.stopOnTurn = options.stopOnTurn;
        this.stopAtStep = options.stopAtStep;
        this.skipInitShuffling = options.skipInitShuffling;
        this.rollbackTurnsAllowed = options.rollbackTurnsAllowed;
        this.bannedUsers.addAll(options.bannedUsers);
        this.planeChase = options.planeChase;
        this.perPlayerEmblemCards = new HashSet<DeckCardInfo>(options.perPlayerEmblemCards);
        this.globalEmblemCards = new HashSet<DeckCardInfo>(options.globalEmblemCards);
    }

    @Override
    public GameOptions copy() {
        return new GameOptions(this);
    }
}

