/*
 * Decompiled with CFR 0.152.
 */
package mage.game;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import mage.MageObject;
import mage.ObjectColor;
import mage.constants.CardType;
import mage.constants.SuperType;
import mage.game.Game;
import mage.util.Copyable;
import mage.util.SubTypes;

public class MageObjectAttribute
implements Serializable,
Copyable<MageObjectAttribute> {
    protected final ObjectColor color;
    protected final SubTypes subtype;
    protected final List<CardType> cardType;
    protected final List<SuperType> superType;

    public MageObjectAttribute(MageObject mageObject, Game game) {
        this.color = mageObject.getColor().copy();
        this.subtype = mageObject.getSubtype(game).copy();
        this.cardType = new ArrayList<CardType>(mageObject.getCardType(game));
        this.superType = new ArrayList<SuperType>(mageObject.getSuperType(game));
    }

    public MageObjectAttribute(MageObjectAttribute mageObjectAttribute) {
        this.color = mageObjectAttribute.color;
        this.subtype = mageObjectAttribute.subtype;
        this.cardType = mageObjectAttribute.cardType;
        this.superType = mageObjectAttribute.superType;
    }

    @Override
    public MageObjectAttribute copy() {
        return new MageObjectAttribute(this);
    }

    public ObjectColor getColor() {
        return this.color;
    }

    public SubTypes getSubtype() {
        return this.subtype;
    }

    public List<CardType> getCardType() {
        return this.cardType;
    }

    public List<SuperType> getSuperType() {
        return this.superType;
    }
}

