/*
 * Decompiled with CFR 0.152.
 */
package mage.game;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import mage.cards.decks.DeckValidator;
import mage.collectors.DataCollectorServices;
import mage.constants.TableState;
import mage.game.GameException;
import mage.game.Seat;
import mage.game.draft.Draft;
import mage.game.events.Listener;
import mage.game.events.TableEvent;
import mage.game.events.TableEventSource;
import mage.game.match.Match;
import mage.game.result.ResultProtos;
import mage.game.tournament.Tournament;
import mage.players.Player;
import mage.players.PlayerType;

public class Table
implements Serializable {
    private static final AtomicInteger GLOBAL_INDEX = new AtomicInteger();
    private UUID tableId;
    private Integer tableIndex;
    private UUID roomId;
    private String name;
    private String controllerName;
    private String gameType;
    private Date createTime;
    private Seat[] seats;
    private int numSeats;
    private boolean isTournament;
    private boolean tournamentSubTable;
    private UUID parentTableId = null;
    private DeckValidator validator;
    private TableState state;
    private Match match;
    private Tournament tournament;
    private TableRecorder recorder;
    private Set<String> bannedUsernames;
    private boolean isPlaneChase;
    protected TableEventSource tableEventSource = new TableEventSource();

    public Table(UUID roomId, String gameType, String name, String controllerName, DeckValidator validator, List<PlayerType> playerTypes, TableRecorder recorder, Tournament tournament, Set<String> bannedUsernames, boolean isPlaneChase) {
        this(roomId, gameType, name, controllerName, validator, playerTypes, recorder, bannedUsernames, isPlaneChase);
        this.tournament = tournament;
        this.isTournament = true;
        this.setState(TableState.WAITING);
        DataCollectorServices.getInstance().onTableStart(this);
    }

    public Table(UUID roomId, String gameType, String name, String controllerName, DeckValidator validator, List<PlayerType> playerTypes, TableRecorder recorder, Match match, Set<String> bannedUsernames, boolean isPlaneChase) {
        this(roomId, gameType, name, controllerName, validator, playerTypes, recorder, bannedUsernames, isPlaneChase);
        this.match = match;
        this.match.setTableId(this.getId());
        this.isTournament = false;
        this.setState(TableState.WAITING);
        DataCollectorServices.getInstance().onTableStart(this);
    }

    protected Table(UUID roomId, String gameType, String name, String controllerName, DeckValidator validator, List<PlayerType> playerTypes, TableRecorder recorder, Set<String> bannedUsernames, boolean isPlaneChase) {
        this.tableId = UUID.randomUUID();
        this.tableIndex = GLOBAL_INDEX.incrementAndGet();
        this.roomId = roomId;
        this.numSeats = playerTypes.size();
        this.gameType = gameType;
        this.name = name;
        this.controllerName = controllerName;
        this.createTime = new Date();
        this.createSeats(playerTypes);
        this.validator = validator;
        this.recorder = recorder;
        this.bannedUsernames = new HashSet<String>(bannedUsernames);
        this.isPlaneChase = isPlaneChase;
    }

    private void createSeats(List<PlayerType> playerTypes) {
        int i = 0;
        this.seats = new Seat[this.numSeats];
        for (PlayerType playerType : playerTypes) {
            this.seats[i] = new Seat(playerType);
            ++i;
        }
    }

    public UUID getId() {
        return this.tableId;
    }

    public Integer getTableIndex() {
        return this.tableIndex;
    }

    public UUID getParentTableId() {
        return this.parentTableId;
    }

    public UUID getRoomId() {
        return this.roomId;
    }

    public void initGame() {
        this.setState(TableState.DUELING);
    }

    public void initTournament() {
        this.setState(TableState.DUELING);
        this.tournament.setStepStartTime(new Date());
    }

    public void endTournament() {
        this.setState(TableState.FINISHED);
    }

    public void initDraft(Draft draft) {
        this.setState(TableState.DRAFTING);
        this.tournament.setStepStartTime(new Date());
        draft.setTableId(this.getId());
    }

    public void construct() {
        this.setState(TableState.CONSTRUCTING);
        this.tournament.setStepStartTime(new Date());
    }

    public void closeTable() {
        if (this.getState() != TableState.WAITING && this.getState() != TableState.READY_TO_START) {
            this.setState(TableState.FINISHED);
        }
        this.validator = null;
        DataCollectorServices.getInstance().onTableEnd(this);
    }

    public void cleanUp() {
        if (this.match != null) {
            this.match.cleanUpOnMatchEnd(false, false);
        }
    }

    public String getGameType() {
        return this.gameType;
    }

    public String getDeckType() {
        if (this.validator != null) {
            return this.validator.getName();
        }
        return "<deck type missing>";
    }

    public Date getCreateTime() {
        return new Date(this.createTime.getTime());
    }

    public boolean isTournament() {
        return this.isTournament;
    }

    public UUID joinTable(Player player, Seat seat) throws GameException {
        if (seat.getPlayer() != null) {
            throw new GameException("Seat is occupied.");
        }
        seat.setPlayer(player);
        if (this.isReady()) {
            this.setState(TableState.READY_TO_START);
        }
        return seat.getPlayer().getId();
    }

    private boolean isReady() {
        for (int i = 0; i < this.numSeats; ++i) {
            if (this.seats[i].getPlayer() != null) continue;
            return false;
        }
        return true;
    }

    public Seat[] getSeats() {
        return this.seats;
    }

    public int getNumberOfSeats() {
        return this.numSeats;
    }

    public Seat getNextAvailableSeat(PlayerType playerType) {
        for (int i = 0; i < this.numSeats; ++i) {
            if (this.seats[i].getPlayer() != null || this.seats[i].getPlayerType() != playerType) continue;
            return this.seats[i];
        }
        return null;
    }

    public boolean allSeatsAreOccupied() {
        for (int i = 0; i < this.numSeats; ++i) {
            if (this.seats[i].getPlayer() != null) continue;
            return false;
        }
        return true;
    }

    public void leaveNotStartedTable(UUID playerId) {
        for (int i = 0; i < this.numSeats; ++i) {
            Player player = this.seats[i].getPlayer();
            if (player == null || !player.getId().equals(playerId)) continue;
            this.seats[i].setPlayer(null);
            if (this.getState() != TableState.READY_TO_START) break;
            this.setState(TableState.WAITING);
            break;
        }
    }

    public final void setState(TableState state) {
        this.state = state;
        if (this.isTournament()) {
            this.getTournament().setTournamentState(state.toString());
        }
        if (state == TableState.FINISHED) {
            this.recorder.record(this);
        }
    }

    public TableState getState() {
        return this.state;
    }

    public DeckValidator getValidator() {
        return this.validator;
    }

    public void sideboard() {
        this.setState(TableState.SIDEBOARDING);
    }

    public String getName() {
        return this.name;
    }

    public void addTableEventListener(Listener<TableEvent> listener) {
        this.tableEventSource.addListener(listener);
    }

    public Match getMatch() {
        return this.match;
    }

    public Tournament getTournament() {
        return this.tournament;
    }

    public void setTournament(Tournament tournament) {
        this.tournament = tournament;
    }

    public String getControllerName() {
        return this.controllerName;
    }

    public boolean isTournamentSubTable() {
        return this.tournamentSubTable;
    }

    public void setTournamentSubTable(UUID parentTableId) {
        this.tournamentSubTable = true;
        this.parentTableId = parentTableId;
    }

    public Date getStartTime() {
        if (this.isTournament) {
            return this.tournament.getStartTime();
        }
        return this.match.getStartTime();
    }

    public Date getEndTime() {
        if (this.isTournament) {
            return this.tournament.getEndTime();
        }
        return this.match.getEndTime();
    }

    public boolean userIsBanned(String username) {
        return this.bannedUsernames.contains(username);
    }

    public ResultProtos.TableProto toProto() {
        ResultProtos.TableProto.Builder builder = ResultProtos.TableProto.newBuilder();
        if (this.isTournament()) {
            builder.getTourneyBuilder().mergeFrom(this.getTournament().toProto());
        } else {
            builder.getMatchBuilder().mergeFrom(this.getMatch().toProto());
        }
        return builder.setGameType(this.getGameType()).setName(this.getName()).setGameType(this.getGameType()).setDeckType(this.getDeckType()).setControllerName(this.getControllerName()).setStartTimeMs(this.getStartTime() != null ? this.getStartTime().getTime() : 0L).setEndTimeMs(this.getEndTime() != null ? this.getEndTime().getTime() : 0L).build();
    }

    @FunctionalInterface
    public static interface TableRecorder {
        public void record(Table var1);
    }
}

