/*
 * Decompiled with CFR 0.152.
 */
package mage.game;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.UUID;
import mage.MageObjectImpl;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.MeldCard;
import mage.cards.ModalDoubleFacedCard;
import mage.cards.ModalDoubleFacedCardHalf;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.game.ZoneChangeInfo;
import mage.game.command.Commander;
import mage.game.events.ZoneChangeEvent;
import mage.game.events.ZoneChangeGroupEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentCard;
import mage.game.permanent.PermanentMeld;
import mage.game.permanent.PermanentToken;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.TargetCard;
import mage.util.FuzzyTestsUtil;

public final class ZonesHandler {
    public static boolean cast(ZoneChangeInfo info, Ability source, Game game) {
        if (ZonesHandler.maybeRemoveFromSourceZone(info, game, source)) {
            ZonesHandler.placeInDestinationZone(info, 0, source, game);
            HashSet<Card> cards = new HashSet<Card>();
            HashSet<PermanentToken> tokens = new HashSet<PermanentToken>();
            Card targetCard = ZonesHandler.getTargetCard(game, info.event.getTargetId());
            if (targetCard instanceof PermanentToken) {
                tokens.add((PermanentToken)targetCard);
            } else {
                cards.add(targetCard);
            }
            game.fireEvent(new ZoneChangeGroupEvent(cards, tokens, info.event.getSourceId(), info.event.getSource(), info.event.getPlayerId(), info.event.getFromZone(), info.event.getToZone()));
            game.fireEvent(info.event);
            return true;
        }
        return false;
    }

    public static boolean moveCard(ZoneChangeInfo info, Game game, Ability source) {
        ArrayList<ZoneChangeInfo> list = new ArrayList<ZoneChangeInfo>();
        list.add(info);
        return !ZonesHandler.moveCards(list, source, game).isEmpty();
    }

    public static List<ZoneChangeInfo> moveCards(List<ZoneChangeInfo> zoneChangeInfos, Ability source, Game game) {
        Card card;
        ZoneChangeInfo info;
        ListIterator<ZoneChangeInfo> itr = zoneChangeInfos.listIterator();
        while (itr.hasNext()) {
            info = itr.next();
            if (info.event.getToZone().equals((Object)Zone.BATTLEFIELD) || (card = game.getMeldCard(info.event.getTargetId())) == null || ((MeldCard)card).isMelded(game) || ((MageObjectImpl)((Object)card)).isCopy()) continue;
            ZoneChangeInfo.Unmelded unmelded = new ZoneChangeInfo.Unmelded(info, game);
            if (unmelded.additionalMoves.isEmpty()) {
                itr.remove();
                continue;
            }
            itr.set(unmelded);
        }
        itr = zoneChangeInfos.listIterator();
        while (itr.hasNext()) {
            info = itr.next();
            if (!info.event.getToZone().equals((Object)Zone.BATTLEFIELD) || !((card = game.getCard(info.event.getTargetId())) instanceof ModalDoubleFacedCard) && !(card instanceof ModalDoubleFacedCardHalf)) continue;
            boolean forceToMainSide = false;
            if (card instanceof ModalDoubleFacedCardHalf && !source.getAbilityType().isPlayCardAbility()) {
                forceToMainSide = true;
            }
            if (card instanceof ModalDoubleFacedCard) {
                forceToMainSide = true;
            }
            if (!forceToMainSide) continue;
            info.event.setTargetId(((ModalDoubleFacedCard)card.getMainCard()).getLeftHalfCard().getId());
        }
        zoneChangeInfos.removeIf(zoneChangeInfo -> !ZonesHandler.maybeRemoveFromSourceZone(zoneChangeInfo, game, source));
        int createOrder = 0;
        for (ZoneChangeInfo zoneChangeInfo2 : zoneChangeInfos) {
            if (createOrder == 0 && Zone.BATTLEFIELD.equals((Object)zoneChangeInfo2.event.getToZone())) {
                createOrder = game.getState().getNextPermanentOrderNumber();
            }
            ZonesHandler.placeInDestinationZone(zoneChangeInfo2, createOrder, source, game);
            if (game.getPhase() == null) continue;
            game.addSimultaneousEvent(zoneChangeInfo2.event);
        }
        return zoneChangeInfos;
    }

    private static void placeInDestinationZone(ZoneChangeInfo info, int createOrder, Ability source, Game game) {
        if (info instanceof ZoneChangeInfo.Unmelded) {
            ZoneChangeInfo.Unmelded unmelded = (ZoneChangeInfo.Unmelded)info;
            Zone toZone = null;
            for (ZoneChangeInfo additionalMove : unmelded.additionalMoves) {
                toZone = additionalMove.event.getToZone();
                ZonesHandler.placeInDestinationZone(additionalMove, createOrder, source, game);
            }
            if (toZone != null) {
                game.setZone(unmelded.event.getTargetId(), toZone);
            }
            return;
        }
        ZoneChangeEvent event = info.event;
        Zone toZone = event.getToZone();
        Card targetCard = ZonesHandler.getTargetCard(game, event.getTargetId());
        Cards cardsToMove = null;
        LinkedHashMap<Zone, CardsImpl> cardsToUpdate = new LinkedHashMap<Zone, CardsImpl>();
        cardsToUpdate.put(toZone, new CardsImpl());
        cardsToUpdate.put(Zone.OUTSIDE, new CardsImpl());
        if (!(targetCard instanceof Permanent) && targetCard != null) {
            if (targetCard instanceof MeldCard) {
                cardsToMove = ((MeldCard)targetCard).getHalves();
                ((Cards)cardsToUpdate.get((Object)toZone)).addAll(cardsToMove);
            } else if (targetCard instanceof ModalDoubleFacedCard || targetCard instanceof ModalDoubleFacedCardHalf) {
                ModalDoubleFacedCard mdfCard = (ModalDoubleFacedCard)targetCard.getMainCard();
                cardsToMove = new CardsImpl(mdfCard);
                ((Cards)cardsToUpdate.get((Object)toZone)).add(mdfCard);
                switch (toZone) {
                    case STACK: 
                    case BATTLEFIELD: {
                        if (targetCard.getId().equals(mdfCard.getLeftHalfCard().getId())) {
                            ((Cards)cardsToUpdate.get((Object)toZone)).add(mdfCard.getLeftHalfCard());
                            ((Cards)cardsToUpdate.get((Object)Zone.OUTSIDE)).add(mdfCard.getRightHalfCard());
                            break;
                        }
                        if (targetCard.getId().equals(mdfCard.getRightHalfCard().getId())) {
                            ((Cards)cardsToUpdate.get((Object)toZone)).add(mdfCard.getRightHalfCard());
                            ((Cards)cardsToUpdate.get((Object)Zone.OUTSIDE)).add(mdfCard.getLeftHalfCard());
                            break;
                        }
                        if (!toZone.equals((Object)Zone.STACK)) {
                            throw new IllegalStateException("Wrong mdf card move to " + (Object)((Object)toZone) + " in placeInDestinationZone");
                        }
                        ((Cards)cardsToUpdate.get((Object)toZone)).add(mdfCard.getLeftHalfCard());
                        ((Cards)cardsToUpdate.get((Object)toZone)).add(mdfCard.getRightHalfCard());
                        break;
                    }
                    default: {
                        ((Cards)cardsToUpdate.get((Object)toZone)).add(mdfCard.getLeftHalfCard());
                        ((Cards)cardsToUpdate.get((Object)toZone)).add(mdfCard.getRightHalfCard());
                        break;
                    }
                }
            } else {
                cardsToMove = new CardsImpl(targetCard);
                ((Cards)cardsToUpdate.get((Object)toZone)).addAll(cardsToMove);
            }
            Player owner = game.getPlayer(targetCard.getOwnerId());
            switch (toZone) {
                case HAND: {
                    for (Card card : cardsToMove.getCards(game)) {
                        game.getPlayer(card.getOwnerId()).getHand().add(card);
                    }
                    break;
                }
                case GRAVEYARD: {
                    for (Card card : ZonesHandler.chooseOrder("order to put in graveyard (last chosen will be on top)", cardsToMove, owner, source, game)) {
                        game.getPlayer(card.getOwnerId()).getGraveyard().add(card);
                    }
                    break;
                }
                case LIBRARY: {
                    if (info instanceof ZoneChangeInfo.Library && ((ZoneChangeInfo.Library)info).top) {
                        for (Card card : ZonesHandler.chooseOrder("order to put on top of library (last chosen will be topmost)", cardsToMove, owner, source, game)) {
                            game.getPlayer(card.getOwnerId()).getLibrary().putOnTop(card, game);
                        }
                    } else {
                        for (Card card : ZonesHandler.chooseOrder("order to put on bottom of library (last chosen will be bottommost)", cardsToMove, owner, source, game)) {
                            game.getPlayer(card.getOwnerId()).getLibrary().putOnBottom(card, game);
                        }
                    }
                    break;
                }
                case EXILED: {
                    for (Card card : cardsToMove.getCards(game)) {
                        if (info instanceof ZoneChangeInfo.Exile && ((ZoneChangeInfo.Exile)info).id != null) {
                            ZoneChangeInfo.Exile exileInfo = (ZoneChangeInfo.Exile)info;
                            game.getExile().createZone(exileInfo.id, exileInfo.name).add(card);
                            continue;
                        }
                        game.getExile().getPermanentExile().add(card);
                    }
                    break;
                }
                case COMMAND: {
                    for (Card card : cardsToMove.getCards(game)) {
                        game.addCommander(new Commander(card));
                    }
                    break;
                }
                case STACK: {
                    for (Card card : cardsToMove.getCards(game)) {
                        Spell spell = info instanceof ZoneChangeInfo.Stack && ((ZoneChangeInfo.Stack)info).spell != null ? ((ZoneChangeInfo.Stack)info).spell : new Spell(card, card.getSpellAbility().copy(), card.getOwnerId(), event.getFromZone(), game);
                        spell.syncZoneChangeCounterOnStack(card, game);
                        game.getState().setZone(spell.getId(), Zone.STACK);
                        game.getState().setZone(card.getId(), Zone.STACK);
                        game.getStack().push(game, spell);
                    }
                    break;
                }
                case BATTLEFIELD: {
                    Permanent permanent = event.getTarget();
                    game.addPermanent(permanent, createOrder);
                    game.getPermanentsEntering().remove(permanent.getId());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("to Zone " + toZone.toString() + " not supported yet");
                }
            }
        }
        game.setZone(event.getTargetId(), event.getToZone());
        cardsToUpdate.entrySet().forEach(entry -> {
            for (Card card : ((Cards)entry.getValue()).getCards(game)) {
                if (card.getId().equals(event.getTargetId())) continue;
                game.setZone(card.getId(), (Zone)((Object)((Object)entry.getKey())));
            }
        });
        if (targetCard instanceof MeldCard && event.getToZone() != Zone.BATTLEFIELD) {
            ((MeldCard)targetCard).setMelded(false, game);
        }
    }

    public static Card getTargetCard(Game game, UUID targetId) {
        Card card = game.getCard(targetId);
        if (card != null) {
            return card;
        }
        card = game.getMeldCard(targetId);
        if (card != null) {
            return card;
        }
        return game.getPermanent(targetId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean maybeRemoveFromSourceZone(ZoneChangeInfo info, Game game, Ability source) {
        boolean wantToTransform;
        ZoneChangeEvent event = info.event;
        if (info instanceof ZoneChangeInfo.Unmelded) {
            ZoneChangeInfo.Unmelded unmelded = (ZoneChangeInfo.Unmelded)info;
            MeldCard meld = game.getMeldCard(event.getTargetId());
            Iterator itr = unmelded.additionalMoves.iterator();
            while (itr.hasNext()) {
                ZoneChangeInfo additionalMove = (ZoneChangeInfo)itr.next();
                if (!ZonesHandler.maybeRemoveFromSourceZone(additionalMove, game, source)) {
                    itr.remove();
                    continue;
                }
                if (Objects.equals(additionalMove.event.getTargetId(), meld.getTopHalfCard().getId())) {
                    meld.setTopLastZoneChangeCounter(meld.getTopHalfCard().getZoneChangeCounter(game));
                    continue;
                }
                if (!Objects.equals(additionalMove.event.getTargetId(), meld.getBottomHalfCard().getId())) continue;
                meld.setBottomLastZoneChangeCounter(meld.getBottomHalfCard().getZoneChangeCounter(game));
            }
            if (unmelded.additionalMoves.isEmpty()) {
                return false;
            }
            meld.updateZoneChangeCounter(game, ((ZoneChangeInfo)unmelded.additionalMoves.get((int)(unmelded.additionalMoves.size() - 1))).event);
            return true;
        }
        Card card = ZonesHandler.getTargetCard(game, event.getTargetId());
        if (card == null) {
            return false;
        }
        boolean isGoodToMove = false;
        isGoodToMove = info.faceDown ? true : (event.getToZone().equals((Object)Zone.BATTLEFIELD) ? ((wantToTransform = Boolean.TRUE.equals(game.getState().getValue("EnterTransformed" + card.getId()))) ? card.isTransformable() && card.getSecondCardFace().isPermanent(game) : card.isPermanent(game)) : true);
        if (!isGoodToMove) {
            return false;
        }
        card.setFaceDown(info.faceDown, game);
        boolean success = false;
        if (!game.replaceEvent(event)) {
            Zone fromZone = event.getFromZone();
            if (event.getToZone() == Zone.BATTLEFIELD) {
                Spell spell;
                PermanentCard permanent;
                if ((card = ZonesHandler.prepareBlueprintCardFromSpell(card, event, game)) instanceof MeldCard) {
                    permanent = new PermanentMeld(card, event.getPlayerId(), game);
                } else {
                    if (card instanceof ModalDoubleFacedCard) {
                        throw new IllegalStateException("Unexpected trying of move mdf card to battlefield instead half");
                    }
                    if (card instanceof Permanent) {
                        throw new IllegalStateException("Unexpected trying of move permanent to battlefield instead card");
                    }
                    permanent = new PermanentCard(card, event.getPlayerId(), game);
                }
                game.getPermanentsEntering().put(permanent.getId(), permanent);
                card.applyEnterWithCounters(permanent, source, game);
                permanent.setTapped(info instanceof ZoneChangeInfo.Battlefield && ((ZoneChangeInfo.Battlefield)info).tapped);
                if (Zone.STACK == event.getFromZone() && (spell = game.getStack().getSpell(event.getTargetId())) != null) {
                    permanent.setPrototyped(spell.isPrototyped());
                }
                permanent.setFaceDown(info.faceDown, game);
                if (info.faceDown) {
                    // empty if block
                }
                game.setScopeRelevant(true);
                try {
                    game.getContinuousEffects().setController(permanent.getId(), permanent.getControllerId());
                    if (permanent.entersBattlefield(source, game, fromZone, true) && card.removeFromZone(game, fromZone, source)) {
                        success = true;
                        event.setTarget(permanent);
                        FuzzyTestsUtil.addRandomPhasedOutPermanent(permanent, source, game);
                    }
                    game.getContinuousEffects().setController(permanent.getId(), permanent.getOwnerId());
                    game.getPermanentsEntering().remove(permanent.getId());
                }
                finally {
                    game.setScopeRelevant(false);
                }
            } else {
                Permanent target;
                success = event.getTarget() != null ? (target = event.getTarget()).removeFromZone(game, fromZone, source) && game.getPlayer(target.getControllerId()).removeFromBattlefield(target, source, game) : card.removeFromZone(game, fromZone, source);
            }
        }
        if (success) {
            if (event.getToZone() == Zone.BATTLEFIELD && event.getTarget() != null) {
                event.getTarget().updateZoneChangeCounter(game, event);
            } else if (!(card instanceof Permanent)) {
                card.updateZoneChangeCounter(game, event);
            }
        }
        return success;
    }

    public static List<Card> chooseOrder(String message, Cards cards, Player player, Ability source, Game game) {
        ArrayList<Card> order = new ArrayList<Card>();
        if (cards.isEmpty()) {
            return order;
        }
        TargetCard target = new TargetCard(Zone.ALL, new FilterCard(message));
        target.setRequired(true);
        while (player.canRespond() && cards.size() > 1) {
            player.choose(Outcome.Neutral, cards, target, source, game);
            Card card = cards.get(target.getFirstTarget(), game);
            if (card == null) break;
            order.add(card);
            cards.remove(target.getFirstTarget());
            target.clearChosen();
        }
        order.addAll(cards.getCards(game));
        return order;
    }

    private static Card prepareBlueprintCardFromSpell(Card card, ZoneChangeEvent event, Game game) {
        Card characteristics;
        Spell spell;
        card = card.copy();
        if (Zone.STACK == event.getFromZone() && (spell = game.getStack().getSpell(event.getTargetId())) != null && spell.getSpellAbility() != null && !(characteristics = spell.getSpellAbility().getCharacteristics(game)).isFaceDown(game) && !card.getColor(game).equals(characteristics.getColor(game))) {
            card.getColor(game).setColor(characteristics.getColor(game));
        }
        return card;
    }
}

