/*
 * Decompiled with CFR 0.152.
 */
package mage.game.combat;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mage.MageItem;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.RequirementEffect;
import mage.abilities.effects.RestrictionEffect;
import mage.abilities.keyword.BandingAbility;
import mage.abilities.keyword.BandsWithOtherAbility;
import mage.abilities.keyword.VigilanceAbility;
import mage.abilities.keyword.special.JohanVigilanceAbility;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterBattlePermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.common.FilterCreatureForCombatBlock;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.filter.predicate.permanent.AttackingSameNotBandedPredicate;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.filter.predicate.permanent.ProtectedByOpponentPredicate;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.events.AttackerDeclaredEvent;
import mage.game.events.DeclareAttackerEvent;
import mage.game.events.DeclareBlockerEvent;
import mage.game.events.DefenderAttackedEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.players.PlayerList;
import mage.target.common.TargetControlledPermanent;
import mage.target.common.TargetDefender;
import mage.util.CardUtil;
import mage.util.Copyable;
import org.apache.log4j.Logger;

public class Combat
implements Serializable,
Copyable<Combat> {
    private static final Logger logger = Logger.getLogger(Combat.class);
    private static FilterCreatureForCombatBlock filterBlockers = new FilterCreatureForCombatBlock();
    private static final FilterPermanent filterBattles = new FilterBattlePermanent();
    private boolean useToughnessForDamage;
    private final List<FilterCreaturePermanent> useToughnessForDamageFilters = new ArrayList<FilterCreaturePermanent>();
    protected List<CombatGroup> groups = new ArrayList<CombatGroup>();
    protected List<CombatGroup> formerGroups = new ArrayList<CombatGroup>();
    protected Map<UUID, CombatGroup> blockingGroups = new LinkedHashMap<UUID, CombatGroup>();
    protected Set<UUID> defenders = new HashSet<UUID>();
    protected Map<UUID, Set<UUID>> numberCreaturesDefenderAttackedBy = new HashMap<UUID, Set<UUID>>();
    protected UUID attackingPlayerId;
    protected Map<UUID, Set<UUID>> creatureMustBlockAttackers = new HashMap<UUID, Set<UUID>>();
    private final Map<UUID, Set<UUID>> creaturesForcedToAttack = new HashMap<UUID, Set<UUID>>();
    private int maxAttackers = Integer.MIN_VALUE;
    private final HashSet<UUID> attackersTappedByAttack = new HashSet();

    public Combat() {
        this.useToughnessForDamage = false;
    }

    protected Combat(Combat combat) {
        this.attackingPlayerId = combat.attackingPlayerId;
        for (CombatGroup combatGroup : combat.groups) {
            this.groups.add(combatGroup.copy());
        }
        for (CombatGroup combatGroup : combat.formerGroups) {
            this.formerGroups.add(combatGroup.copy());
        }
        this.defenders.addAll(combat.defenders);
        for (Map.Entry entry : combat.blockingGroups.entrySet()) {
            this.blockingGroups.put((UUID)entry.getKey(), (CombatGroup)entry.getValue());
        }
        this.useToughnessForDamage = combat.useToughnessForDamage;
        for (Map.Entry entry : combat.numberCreaturesDefenderAttackedBy.entrySet()) {
            this.numberCreaturesDefenderAttackedBy.put((UUID)entry.getKey(), (Set<UUID>)entry.getValue());
        }
        for (Map.Entry entry : combat.creatureMustBlockAttackers.entrySet()) {
            this.creatureMustBlockAttackers.put((UUID)entry.getKey(), (Set<UUID>)entry.getValue());
        }
        for (Map.Entry entry : combat.creaturesForcedToAttack.entrySet()) {
            this.creaturesForcedToAttack.put((UUID)entry.getKey(), (Set<UUID>)entry.getValue());
        }
        this.maxAttackers = combat.maxAttackers;
        this.attackersTappedByAttack.addAll(combat.attackersTappedByAttack);
    }

    public List<CombatGroup> getGroups() {
        return this.groups;
    }

    public Collection<CombatGroup> getBlockingGroups() {
        return this.blockingGroups.values();
    }

    public boolean blockingGroupsContains(UUID blockerId) {
        return this.blockingGroups.containsKey(blockerId);
    }

    public Set<UUID> getDefenders() {
        return this.defenders;
    }

    public Set<UUID> getAttackers() {
        HashSet<UUID> attackers = new HashSet<UUID>();
        for (CombatGroup group : this.groups) {
            attackers.addAll(group.attackers);
        }
        return attackers;
    }

    public Set<UUID> getBlockers() {
        HashSet<UUID> blockers = new HashSet<UUID>();
        for (CombatGroup group : this.groups) {
            blockers.addAll(group.blockers);
        }
        return blockers;
    }

    public boolean useToughnessForDamage(Permanent permanent, Game game) {
        if (this.useToughnessForDamage) {
            for (FilterCreaturePermanent filter : this.useToughnessForDamageFilters) {
                if (!filter.match(permanent, game)) continue;
                return true;
            }
        }
        return false;
    }

    public void setUseToughnessForDamage(boolean useToughnessForDamage) {
        this.useToughnessForDamage = useToughnessForDamage;
    }

    public void addUseToughnessForDamageFilter(FilterCreaturePermanent filter) {
        this.useToughnessForDamageFilters.add(filter);
    }

    public void reset(Game game) {
        this.useToughnessForDamage = false;
        this.useToughnessForDamageFilters.clear();
    }

    public void checkForRemoveFromCombat(Game game) {
        Permanent creature;
        for (UUID creatureId : this.getAttackers()) {
            creature = game.getPermanent(creatureId);
            if (creature == null || creature.isCreature(game)) continue;
            this.removeFromCombat(creatureId, game, true);
        }
        for (UUID creatureId : this.getBlockers()) {
            creature = game.getPermanent(creatureId);
            if (creature == null || creature.isCreature(game)) continue;
            this.removeFromCombat(creatureId, game, true);
        }
    }

    public void clear() {
        this.groups.clear();
        this.formerGroups.clear();
        this.blockingGroups.clear();
        this.defenders.clear();
        this.attackingPlayerId = null;
        this.creatureMustBlockAttackers.clear();
        this.numberCreaturesDefenderAttackedBy.clear();
        this.creaturesForcedToAttack.clear();
        this.maxAttackers = Integer.MIN_VALUE;
        this.attackersTappedByAttack.clear();
    }

    public String getValue() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.attackingPlayerId).append(this.defenders);
        for (CombatGroup group : this.groups) {
            sb.append(group.defenderId).append(group.attackers).append(group.blockers);
        }
        return sb.toString();
    }

    public void setAttacker(UUID playerId) {
        this.attackingPlayerId = playerId;
    }

    public boolean addAttackingCreature(UUID creatureId, Game game) {
        return this.addAttackingCreature(creatureId, game, null);
    }

    public boolean addAttackingCreature(UUID creatureId, Game game, UUID playerToAttack) {
        Player player;
        HashSet<Object> possibleDefenders;
        if (playerToAttack != null) {
            possibleDefenders = new HashSet();
            for (UUID objectId : this.defenders) {
                if (playerToAttack.equals(objectId)) {
                    possibleDefenders.add(objectId);
                    continue;
                }
                Permanent permanent = game.getPermanent(objectId);
                if (permanent == null || !permanent.canBeAttacked(creatureId, playerToAttack, game)) continue;
                possibleDefenders.add(objectId);
            }
        } else {
            possibleDefenders = new HashSet<UUID>(this.defenders);
        }
        if ((player = game.getPlayer(this.attackingPlayerId)) == null) {
            return false;
        }
        if (possibleDefenders.size() == 1) {
            this.addAttackerToCombat(creatureId, (UUID)possibleDefenders.iterator().next(), game);
            return true;
        }
        TargetDefender target = new TargetDefender(possibleDefenders);
        target.setRequired(true);
        player.chooseTarget(Outcome.Damage, target, null, game);
        if (target.getFirstTarget() != null) {
            this.addAttackerToCombat(creatureId, target.getFirstTarget(), game);
            return true;
        }
        return false;
    }

    public void selectAttackers(Game game) {
        if (!game.replaceEvent(GameEvent.getEvent(GameEvent.EventType.DECLARING_ATTACKERS, this.attackingPlayerId, this.attackingPlayerId))) {
            Player player = game.getPlayer(this.attackingPlayerId);
            if (player != null) {
                game.getCombat().checkAttackRequirements(player, game);
                boolean firstTime = true;
                do {
                    if (!firstTime || !game.getPlayer(game.getActivePlayerId()).getAvailableAttackers(game).isEmpty()) {
                        player.selectAttackers(game, this.attackingPlayerId);
                    }
                    firstTime = false;
                    if (!game.isPaused() && !game.checkIfGameIsOver() && !game.executingRollback()) continue;
                    return;
                } while (!game.getCombat().checkAttackRestrictions(player, game));
            }
            game.getCombat().resumeSelectAttackers(game);
        }
    }

    public void resumeSelectAttackers(Game game) {
        Player player;
        HashMap<UUID, Set<MageObjectReference>> morSetMap = new HashMap<UUID, Set<MageObjectReference>>();
        for (CombatGroup group : this.groups) {
            for (UUID attacker : group.getAttackers()) {
                Permanent attackingPermanent;
                if (this.attackersTappedByAttack.contains(attacker) && (attackingPermanent = game.getPermanent(attacker)) != null) {
                    attackingPermanent.setTapped(false);
                    attackingPermanent.tap(true, null, game);
                }
                this.handleBanding(attacker, game);
                game.replaceEvent(new AttackerDeclaredEvent(group.defenderId, attacker, this.attackingPlayerId));
                game.addSimultaneousEvent(new AttackerDeclaredEvent(group.defenderId, attacker, this.attackingPlayerId));
                morSetMap.computeIfAbsent(group.defenderId, x -> new HashSet()).add(new MageObjectReference(attacker, game));
            }
        }
        this.attackersTappedByAttack.clear();
        DefenderAttackedEvent.makeAddEvents(morSetMap, this.attackingPlayerId, game);
        game.addSimultaneousEvent(GameEvent.getEvent(GameEvent.EventType.DECLARED_ATTACKERS, this.attackingPlayerId, this.attackingPlayerId));
        if (!game.isSimulation() && (player = game.getPlayer(this.attackingPlayerId)) != null) {
            if (this.groups.size() > 0) {
                String defendersInfo = this.groups.stream().map(g -> g.defenderId).distinct().map(id -> {
                    Player defPlayer = game.getPlayer((UUID)id);
                    if (defPlayer != null) {
                        return defPlayer.getLogName();
                    }
                    Permanent defPermanent = game.getPermanentOrLKIBattlefield((UUID)id);
                    if (defPermanent != null) {
                        return defPermanent.getLogName();
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.joining(", "));
                game.informPlayers(player.getLogName() + " attacks " + defendersInfo + " with " + this.groups.size() + (this.groups.size() == 1 ? " creature" : " creatures"));
            } else {
                game.informPlayers(player.getLogName() + " skip attack");
            }
        }
    }

    private void handleBanding(UUID creatureId, Game game) {
        boolean canBandWithOther;
        Player player = game.getPlayer(this.attackingPlayerId);
        Permanent attacker = game.getPermanent(creatureId);
        if (attacker == null || player == null) {
            return;
        }
        CombatGroup combatGroup = this.findGroup(attacker.getId());
        if (combatGroup == null || !attacker.getBandedCards().isEmpty() || this.getAttackers().size() <= 1) {
            return;
        }
        boolean canBand = attacker.hasAbility(BandingAbility.getInstance(), game);
        ArrayList<Ability> bandsWithOther = new ArrayList<Ability>();
        for (Ability ability : attacker.getAbilities()) {
            if (!ability.getClass().equals(BandsWithOtherAbility.class)) continue;
            bandsWithOther.add(ability);
        }
        boolean bl = canBandWithOther = !bandsWithOther.isEmpty();
        if (!canBand && !canBandWithOther) {
            return;
        }
        boolean isBanded = false;
        FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("attacking creature to band with " + attacker.getLogName());
        filter.add(Predicates.not(new PermanentIdPredicate(creatureId)));
        filter.add(new AttackingSameNotBandedPredicate(combatGroup.getDefenderId()));
        ArrayList<Predicate<MageObject>> predicates = new ArrayList<Predicate<MageObject>>();
        if (!canBand && canBandWithOther) {
            for (Ability ability : bandsWithOther) {
                BandsWithOtherAbility ability2 = (BandsWithOtherAbility)ability;
                if (ability2.getSubtype() != null) {
                    predicates.add(ability2.getSubtype().getPredicate());
                }
                if (ability2.getSupertype() != null) {
                    predicates.add(ability2.getSupertype().getPredicate());
                }
                if (ability2.getName() == null) continue;
                predicates.add(new NamePredicate(ability2.getName()));
            }
            filter.add(Predicates.or(predicates));
        }
        while (player.canRespond()) {
            TargetControlledPermanent target = new TargetControlledPermanent(1, 1, filter, true);
            target.setRequired(false);
            if (game.replaceEvent(GameEvent.getEvent(GameEvent.EventType.DECLARING_ATTACKERS, this.attackingPlayerId, this.attackingPlayerId)) || !(canBand &= target.canChoose(this.attackingPlayerId, game)) && !(canBandWithOther &= target.canChoose(this.attackingPlayerId, game)) || !player.chooseUse(Outcome.Benefit, (isBanded ? "Band " + attacker.getLogName() + " with another " : "Form a band with " + attacker.getLogName() + " and an ") + "attacking creature?", null, game)) break;
            if (canBand && canBandWithOther) {
                if (player.chooseUse(Outcome.Detriment, "Choose type of banding ability to apply:", attacker.getLogName(), "Banding", "Bands with other", null, game)) {
                    canBandWithOther = false;
                } else {
                    canBand = false;
                    for (Ability ab : bandsWithOther) {
                        BandsWithOtherAbility ability = (BandsWithOtherAbility)ab;
                        if (ability.getSubtype() != null) {
                            predicates.add(ability.getSubtype().getPredicate());
                        }
                        if (ability.getSupertype() != null) {
                            predicates.add(ability.getSupertype().getPredicate());
                        }
                        if (ability.getName() == null) continue;
                        predicates.add(new NamePredicate(ability.getName()));
                    }
                    filter.add(Predicates.or(predicates));
                }
            }
            if (!target.choose(Outcome.Benefit, this.attackingPlayerId, null, null, game)) continue;
            isBanded = true;
            for (UUID targetId : target.getTargets()) {
                Permanent permanent = game.getPermanent(targetId);
                if (permanent == null) continue;
                for (UUID bandedId : attacker.getBandedCards()) {
                    permanent.addBandedCard(bandedId);
                    Permanent permanent2 = game.getPermanent(bandedId);
                    if (permanent2 == null) continue;
                    permanent2.addBandedCard(targetId);
                }
                permanent.addBandedCard(creatureId);
                attacker.addBandedCard(targetId);
                if (canBand) {
                    if (permanent.hasAbility(BandingAbility.getInstance(), game)) continue;
                    filter.add(new AbilityPredicate(BandingAbility.class));
                    canBandWithOther = false;
                    continue;
                }
                if (!canBandWithOther) continue;
                ArrayList<Predicate> newPredicates = new ArrayList<Predicate>();
                for (Predicate predicate : predicates) {
                    if (!predicate.apply(permanent, game)) continue;
                    newPredicates.add(predicate);
                }
                filter.add(Predicates.or(newPredicates));
                canBand = false;
            }
        }
        if (!isBanded) {
            return;
        }
        int bandSize = attacker.getBandedCards().size() + 1;
        StringBuilder stringBuilder = new StringBuilder(player.getLogName()).append(" formed a band with ").append(bandSize).append(" creatures: ");
        stringBuilder.append(attacker.getLogName());
        for (UUID id : attacker.getBandedCards()) {
            stringBuilder.append(", ");
            Permanent permanent = game.getPermanent(id);
            if (permanent == null) continue;
            stringBuilder.append(permanent.getLogName());
        }
        game.informPlayers(stringBuilder.toString());
    }

    protected void checkAttackRequirements(Player player, Game game) {
        for (Permanent creature : player.getAvailableAttackers(game)) {
            HashSet<UUID> defendersToChooseFrom;
            Map.Entry<RequirementEffect, Set<Ability>> entry22;
            boolean mustAttack = false;
            HashSet<UUID> defendersForcedToAttack = new HashSet<UUID>();
            if (creature.getGoadingPlayers().isEmpty()) {
                for (Map.Entry<RequirementEffect, Set<Ability>> entry22 : game.getContinuousEffects().getApplicableRequirementEffects(creature, false, game).entrySet()) {
                    Ability ability2;
                    UUID defenderId;
                    RequirementEffect effect = entry22.getKey();
                    if (!effect.mustAttack(game)) continue;
                    mustAttack = true;
                    Iterator<Object> iterator = ((Set)entry22.getValue()).iterator();
                    if (!iterator.hasNext() || (defenderId = effect.mustAttackDefender(ability2 = (Ability)iterator.next(), game)) == null) continue;
                    if (game.getPermanentOrLKIBattlefield(defenderId) == null && game.getPlayer(defenderId).hasLost()) {
                        return;
                    }
                    if (!this.defenders.contains(defenderId)) continue;
                    defendersForcedToAttack.add(defenderId);
                }
            } else {
                mustAttack = true;
                defendersForcedToAttack.addAll(this.defenders.stream().map(game::getPlayer).filter(Objects::nonNull).map(MageItem::getId).collect(Collectors.toSet()));
            }
            if (!mustAttack) continue;
            HashSet<UUID> defendersCostlessAttackable = new HashSet<UUID>(this.defenders);
            entry22 = this.defenders.iterator();
            block2: while (entry22.hasNext()) {
                UUID defenderId = (UUID)entry22.next();
                if (game.getContinuousEffects().checkIfThereArePayCostToAttackBlockEffects(new DeclareAttackerEvent(defenderId, creature.getId(), creature.getControllerId()), game)) {
                    defendersCostlessAttackable.remove(defenderId);
                    defendersForcedToAttack.remove(defenderId);
                    continue;
                }
                for (Map.Entry entry : game.getContinuousEffects().getApplicableRestrictionEffects(creature, game).entrySet()) {
                    if (((Set)entry.getValue()).stream().anyMatch(ability -> ((RestrictionEffect)entry3.getKey()).canAttack(creature, defenderId, (Ability)ability, game, false))) continue;
                    defendersCostlessAttackable.remove(defenderId);
                    defendersForcedToAttack.remove(defenderId);
                    continue block2;
                }
            }
            defendersForcedToAttack.removeAll(creature.getGoadingPlayers());
            if (defendersCostlessAttackable.isEmpty()) continue;
            this.creaturesForcedToAttack.put(creature.getId(), defendersForcedToAttack);
            HashSet<UUID> hashSet = defendersToChooseFrom = defendersForcedToAttack.isEmpty() ? defendersCostlessAttackable : defendersForcedToAttack;
            if (defendersToChooseFrom.size() == 1) {
                player.declareAttacker(creature.getId(), (UUID)defendersToChooseFrom.iterator().next(), game, false);
                continue;
            }
            TargetDefender target = new TargetDefender(defendersToChooseFrom);
            target.setRequired(true);
            target.withTargetName("permanent or player for " + creature.getLogName() + " to attack (must attack effect)");
            if (!player.chooseTarget(Outcome.Damage, target, null, game)) continue;
            player.declareAttacker(creature.getId(), target.getFirstTarget(), game, false);
        }
    }

    protected boolean checkAttackRestrictions(Player player, Game game) {
        boolean check = true;
        int numberOfChecks = 0;
        UUID attackerToRemove = null;
        Player attackingPlayer = game.getPlayer(this.attackingPlayerId);
        block0: while (check) {
            check = false;
            ++numberOfChecks;
            int numberAttackers = 0;
            for (CombatGroup group : this.groups) {
                numberAttackers += group.getAttackers().size();
            }
            if (attackerToRemove != null) {
                this.removeAttacker(attackerToRemove, game);
            }
            for (UUID attackingCreatureId : this.getAttackers()) {
                Permanent attackingCreature = game.getPermanent(attackingCreatureId);
                for (Map.Entry<RestrictionEffect, Set<Ability>> entry : game.getContinuousEffects().getApplicableRestrictionEffects(attackingCreature, game).entrySet()) {
                    RestrictionEffect effect = entry.getKey();
                    for (Ability ability : entry.getValue()) {
                        if (effect.canAttackCheckAfter(numberAttackers, ability, game, true)) continue;
                        MageObject sourceObject = ability.getSourceObject(game);
                        if (attackingPlayer.isHuman()) {
                            attackingPlayer.resetPlayerPassedActions();
                            game.informPlayer(attackingPlayer, attackingCreature.getIdName() + " can't attack this way (" + (sourceObject == null ? "null" : sourceObject.getIdName()) + ')');
                            return false;
                        }
                        if (this.getGroups().stream().map(CombatGroup::getAttackers).flatMap(Collection::stream).anyMatch(attackingCreatureId::equals)) {
                            attackerToRemove = attackingCreatureId;
                        }
                        check = true;
                        if (numberOfChecks <= 50) continue block0;
                        logger.error((Object)("Seems to be an AI declare attacker lock (reached 50 check iterations) " + (sourceObject == null ? "null" : sourceObject.getIdName())));
                        return true;
                    }
                }
            }
        }
        return true;
    }

    public void selectBlockers(Game game) {
        if (!game.replaceEvent(GameEvent.getEvent(GameEvent.EventType.DECLARING_BLOCKERS, this.attackingPlayerId, this.attackingPlayerId))) {
            game.getCombat().selectBlockers(null, null, game);
        }
        for (UUID attackingCreatureID : game.getCombat().getAttackers()) {
            Permanent permanent = game.getPermanent(attackingCreatureID);
            CombatGroup group = game.getCombat().findGroup(attackingCreatureID);
            if (permanent == null || group == null || group.getBlocked()) continue;
            game.fireEvent(GameEvent.getEvent(GameEvent.EventType.UNBLOCKED_ATTACKER, attackingCreatureID, this.attackingPlayerId));
        }
    }

    public void selectBlockers(Player blockController, Ability source, Game game) {
        Player attacker = game.getPlayer(this.attackingPlayerId);
        game.getCombat().retrieveMustBlockAttackerRequirements(attacker, game);
        for (UUID defenderId : this.getPlayerDefenders(game)) {
            Player defender = game.getPlayer(defenderId);
            if (defender == null) continue;
            Player controller = blockController == null ? defender : blockController;
            int aiTries = 0;
            while (true) {
                if (controller.isComputer() && ++aiTries > 20) {
                    game.informPlayers(controller.getLogName() + ": WARNING - AI can't find good blocker combination and will skip it - report your battlefield to github - " + game.getCombat());
                    if (!controller.isTestMode() || !controller.isFastFailInTestMode()) break;
                    throw new IllegalArgumentException("AI can't find good blocker combination");
                }
                controller.selectBlockers(source, game, defenderId);
                if (game.isPaused() || game.checkIfGameIsOver() || game.executingRollback()) {
                    return;
                }
                boolean isValidBlock = game.getCombat().checkBlockRestrictions(defender, game);
                if (!isValidBlock) {
                    this.makeSureItsNotComputer(controller);
                    continue;
                }
                isValidBlock = game.getCombat().checkBlockRequirementsAfter(defender, controller, game);
                if (!isValidBlock) {
                    this.makeSureItsNotComputer(controller);
                    continue;
                }
                isValidBlock = game.getCombat().checkBlockRestrictionsAfter(defender, controller, game);
                if (isValidBlock) break;
                this.makeSureItsNotComputer(controller);
            }
            game.fireEvent(GameEvent.getEvent(GameEvent.EventType.DECLARED_BLOCKERS, defenderId, defenderId));
            if (game.isSimulation()) continue;
            game.getCombat().logBlockerInfo(defender, game);
        }
    }

    private void makeSureItsNotComputer(Player controller) {
        if (controller.isComputer() || !controller.isHuman()) {
            // empty if block
        }
    }

    private void logBlockerInfo(Player defender, Game game) {
        boolean shownDefendingPlayer = game.getPlayers().size() <= 2;
        for (CombatGroup group : game.getCombat().getGroups()) {
            if (!group.defendingPlayerId.equals(defender.getId())) continue;
            if (!shownDefendingPlayer) {
                game.informPlayers("Attacked player: " + defender.getLogName());
                shownDefendingPlayer = true;
            }
            StringBuilder sb = new StringBuilder();
            boolean attackerExists = false;
            for (UUID attackingCreatureId : group.getAttackers()) {
                attackerExists = true;
                Permanent attackingCreature = game.getPermanent(attackingCreatureId);
                if (attackingCreature != null) {
                    sb.append("Attacker: ");
                    sb.append(attackingCreature.getLogName()).append(" (");
                    sb.append(attackingCreature.getPower().getValue()).append('/').append(attackingCreature.getToughness().getValue()).append(") ");
                    continue;
                }
                attackingCreature = (Permanent)game.getLastKnownInformation(attackingCreatureId, Zone.BATTLEFIELD);
                if (attackingCreature == null) continue;
                sb.append(attackingCreature.getLogName()).append(" [left battlefield)] ");
            }
            if (attackerExists) {
                if (!group.getBlockers().isEmpty()) {
                    sb.append("blocked by ");
                    for (UUID blockingCreatureId : group.getBlockers()) {
                        Permanent blockingCreature = game.getPermanent(blockingCreatureId);
                        if (blockingCreature == null) continue;
                        sb.append(blockingCreature.getLogName()).append(" (");
                        sb.append(blockingCreature.getPower().getValue()).append('/').append(blockingCreature.getToughness().getValue()).append(") ");
                    }
                } else {
                    sb.append("unblocked");
                }
            }
            game.informPlayers(sb.toString());
        }
    }

    public boolean checkBlockRestrictions(Player defender, Game game) {
        int count = 0;
        boolean blockWasLegal = true;
        for (CombatGroup group : this.groups) {
            count += group.getBlockers().size();
        }
        for (CombatGroup group : this.groups) {
            blockWasLegal &= group.checkBlockRestrictions(game, defender, count);
        }
        return blockWasLegal;
    }

    public void acceptBlockers(Game game) {
        for (CombatGroup group : this.groups) {
            group.acceptBlockers(game);
        }
        for (UUID blockerId : this.getBlockers()) {
            game.fireEvent(GameEvent.getEvent(GameEvent.EventType.CREATURE_BLOCKS, blockerId, null));
        }
    }

    public void resumeSelectBlockers(Game game) {
        for (UUID defenderId : this.getPlayerDefenders(game)) {
            game.fireEvent(GameEvent.getEvent(GameEvent.EventType.DECLARED_BLOCKERS, defenderId, defenderId));
        }
    }

    private void retrieveMustBlockAttackerRequirements(Player attackingPlayer, Game game) {
        if (attackingPlayer == null) {
            return;
        }
        if (!game.getContinuousEffects().existRequirementEffects()) {
            return;
        }
        for (Permanent possibleBlocker : game.getBattlefield().getActivePermanents(filterBlockers, attackingPlayer.getId(), game)) {
            for (Map.Entry<RequirementEffect, Set<Ability>> requirementEntry : game.getContinuousEffects().getApplicableRequirementEffects(possibleBlocker, false, game).entrySet()) {
                if (!requirementEntry.getKey().mustBlock(game)) continue;
                for (Ability ability : requirementEntry.getValue()) {
                    Permanent attackingCreature;
                    UUID attackingCreatureId = requirementEntry.getKey().mustBlockAttacker(ability, game);
                    Player defender = game.getPlayer(possibleBlocker.getControllerId());
                    if (attackingCreatureId == null || defender == null || !possibleBlocker.canBlock(attackingCreatureId, game) || (attackingCreature = game.getPermanent(attackingCreatureId)) == null || !attackingCreature.isAttacking() || game.getContinuousEffects().checkIfThereArePayCostToAttackBlockEffects(new DeclareBlockerEvent(attackingCreatureId, possibleBlocker.getId(), possibleBlocker.getControllerId()), game) || !this.getDefendingPlayerId(attackingCreatureId, game).equals(possibleBlocker.getControllerId())) continue;
                    if (this.creatureMustBlockAttackers.containsKey(possibleBlocker.getId())) {
                        this.creatureMustBlockAttackers.get(possibleBlocker.getId()).add(attackingCreatureId);
                        continue;
                    }
                    HashSet<UUID> forcingAttackers = new HashSet<UUID>();
                    forcingAttackers.add(attackingCreatureId);
                    this.creatureMustBlockAttackers.put(possibleBlocker.getId(), forcingAttackers);
                    defender.declareBlocker(defender.getId(), possibleBlocker.getId(), attackingCreatureId, game, false);
                }
            }
        }
    }

    public boolean checkBlockRequirementsAfter(Player player, Player controller, Game game) {
        Set<UUID> opponents = game.getOpponents(this.attackingPlayerId);
        HashMap<UUID, Set<UUID>> mustBeBlockedByAtLeastX = new HashMap<UUID, Set<UUID>>();
        HashMap minNumberOfBlockersMap = new HashMap();
        HashMap minPossibleBlockersMap = new HashMap();
        for (Permanent creature : game.getBattlefield().getActivePermanents(StaticFilters.FILTER_PERMANENT_CREATURES_CONTROLLED, player.getId(), game)) {
            Set<UUID> potentialBlockers;
            Object toBeBlockedCreature;
            RequirementEffect effect;
            if (!opponents.contains(creature.getControllerId())) continue;
            if (creature.getBlocking() > 0) {
                for (Map.Entry entry : game.getContinuousEffects().getApplicableRequirementEffects(creature, false, game).entrySet()) {
                    boolean bl;
                    effect = (RequirementEffect)entry.getKey();
                    for (Ability ability : (Set)entry.getValue()) {
                        CombatGroup combatGroup;
                        toBeBlockedCreature = effect.mustBlockAttackerIfElseUnblocked(ability, game);
                        if (toBeBlockedCreature == null || (combatGroup = this.findGroup((UUID)toBeBlockedCreature)) == null || !combatGroup.getDefendingPlayerId().equals(creature.getControllerId())) continue;
                        minNumberOfBlockersMap.put(toBeBlockedCreature, effect.getMinNumberOfBlockers());
                        Permanent toBeBlockedCreaturePermanent = game.getPermanent((UUID)toBeBlockedCreature);
                        if (toBeBlockedCreaturePermanent != null) {
                            minPossibleBlockersMap.put(toBeBlockedCreature, toBeBlockedCreaturePermanent.getMinBlockedBy());
                        } else {
                            minPossibleBlockersMap.put(toBeBlockedCreature, 1);
                        }
                        if (mustBeBlockedByAtLeastX.containsKey(toBeBlockedCreature)) {
                            potentialBlockers = (Set)mustBeBlockedByAtLeastX.get(toBeBlockedCreature);
                        } else {
                            potentialBlockers = new HashSet();
                            mustBeBlockedByAtLeastX.put((UUID)toBeBlockedCreature, potentialBlockers);
                        }
                        potentialBlockers.add(creature.getId());
                    }
                    if (!effect.mustBlockAllAttackers(game)) continue;
                    HashSet<UUID> attackersToBlock = new HashSet<UUID>();
                    boolean bl2 = false;
                    for (UUID uUID : this.getAttackers()) {
                        int alreadyBlockingCreatures;
                        Permanent attackingCreature2;
                        if (!creature.canBlock(uUID, game) || (attackingCreature2 = game.getPermanent(uUID)) == null) continue;
                        if (attackingCreature2.getMaxBlockedBy() != 0) {
                            alreadyBlockingCreatures = 0;
                            for (CombatGroup group : this.getGroups()) {
                                if (!group.getAttackers().contains(uUID)) continue;
                                alreadyBlockingCreatures = group.getBlockers().size();
                                break;
                            }
                            if (attackingCreature2.getMaxBlockedBy() <= alreadyBlockingCreatures) continue;
                        }
                        if (attackingCreature2.getMinBlockedBy() > 1) {
                            alreadyBlockingCreatures = 0;
                            for (CombatGroup group : this.getGroups()) {
                                if (!group.getAttackers().contains(uUID)) continue;
                                alreadyBlockingCreatures = group.getBlockers().size();
                                break;
                            }
                            if (attackingCreature2.getMinBlockedBy() < alreadyBlockingCreatures) continue;
                            continue;
                        }
                        attackersToBlock.add(uUID);
                    }
                    if (!attackersToBlock.isEmpty()) {
                        for (UUID uUID : attackersToBlock) {
                            if (this.findGroup(uUID).getBlockers().contains(creature.getId())) continue;
                            bl = true;
                            break;
                        }
                    }
                    if (!bl) continue;
                    if (controller.isHuman()) {
                        controller.resetPlayerPassedActions();
                        game.informPlayer(controller, "Creature should block all attackers it's able to this turn: " + creature.getIdName());
                    } else {
                        Player defender = game.getPlayer(creature.getControllerId());
                        if (defender != null) {
                            for (UUID attackingCreatureId : this.getAttackers()) {
                                if (!creature.canBlock(attackingCreatureId, game) || this.findGroup(attackingCreatureId).getBlockers().contains(creature.getId()) || !attackersToBlock.contains(attackingCreatureId)) continue;
                                defender.declareBlocker(defender.getId(), creature.getId(), attackingCreatureId, game);
                            }
                        }
                    }
                    return false;
                }
            }
            if (creature.getBlocking() != 0) continue;
            for (Map.Entry entry : game.getContinuousEffects().getApplicableRequirementEffects(creature, false, game).entrySet()) {
                effect = (RequirementEffect)entry.getKey();
                for (Ability ability : (Set)entry.getValue()) {
                    CombatGroup combatGroup;
                    toBeBlockedCreature = effect.mustBlockAttackerIfElseUnblocked(ability, game);
                    if (toBeBlockedCreature == null || (combatGroup = this.findGroup((UUID)toBeBlockedCreature)) == null || !combatGroup.getDefendingPlayerId().equals(creature.getControllerId())) continue;
                    minNumberOfBlockersMap.put(toBeBlockedCreature, effect.getMinNumberOfBlockers());
                    Permanent toBeBlockedCreaturePermanent = game.getPermanent((UUID)toBeBlockedCreature);
                    if (toBeBlockedCreaturePermanent != null) {
                        minPossibleBlockersMap.put(toBeBlockedCreature, toBeBlockedCreaturePermanent.getMinBlockedBy());
                    } else {
                        minPossibleBlockersMap.put(toBeBlockedCreature, 1);
                    }
                    if (mustBeBlockedByAtLeastX.containsKey(toBeBlockedCreature)) {
                        potentialBlockers = (Set)mustBeBlockedByAtLeastX.get(toBeBlockedCreature);
                    } else {
                        potentialBlockers = new HashSet();
                        mustBeBlockedByAtLeastX.put((UUID)toBeBlockedCreature, potentialBlockers);
                    }
                    potentialBlockers.add(creature.getId());
                }
                if (!effect.mustBlockAny(game) && !effect.mustBlockAllAttackers(game)) continue;
                boolean mayBlock = false;
                for (Object attackingCreatureId : this.getAttackers()) {
                    int alreadyBlockingCreatures;
                    Permanent permanent;
                    if (!creature.canBlock((UUID)attackingCreatureId, game) || (permanent = game.getPermanent((UUID)attackingCreatureId)) == null) continue;
                    if (permanent.getMaxBlockedBy() != 0) {
                        alreadyBlockingCreatures = 0;
                        for (CombatGroup group : this.getGroups()) {
                            if (!group.getAttackers().contains(attackingCreatureId)) continue;
                            alreadyBlockingCreatures = group.getBlockers().size();
                            break;
                        }
                        if (permanent.getMaxBlockedBy() <= alreadyBlockingCreatures) continue;
                    }
                    if (permanent.getMinBlockedBy() > 1) {
                        alreadyBlockingCreatures = 0;
                        for (CombatGroup group : this.getGroups()) {
                            if (!group.getAttackers().contains(attackingCreatureId)) continue;
                            alreadyBlockingCreatures = group.getBlockers().size();
                            break;
                        }
                        if (permanent.getMinBlockedBy() < alreadyBlockingCreatures) continue;
                        continue;
                    }
                    mayBlock = true;
                    break;
                }
                if (!mayBlock) continue;
                if (controller.isHuman()) {
                    controller.resetPlayerPassedActions();
                    game.informPlayer(controller, "Creature should block this turn: " + creature.getIdName());
                } else {
                    Player player2 = game.getPlayer(creature.getControllerId());
                    if (player2 != null) {
                        for (UUID uUID : this.getAttackers()) {
                            if (!creature.canBlock(uUID, game) || this.findGroup(uUID).getBlockers().contains(creature.getId())) continue;
                            player2.declareBlocker(player2.getId(), creature.getId(), uUID, game);
                            break;
                        }
                    }
                }
                return false;
            }
        }
        for (UUID toBeBlockedCreatureId : mustBeBlockedByAtLeastX.keySet()) {
            block15: for (CombatGroup combatGroup : game.getCombat().getGroups()) {
                if (!combatGroup.getAttackers().contains(toBeBlockedCreatureId) || ((Set)mustBeBlockedByAtLeastX.get(toBeBlockedCreatureId)).size() < (Integer)minPossibleBlockersMap.get(toBeBlockedCreatureId)) continue;
                boolean requirementFulfilled = false;
                for (UUID uUID : combatGroup.getBlockers()) {
                    if (!((Set)mustBeBlockedByAtLeastX.get(toBeBlockedCreatureId)).contains(uUID)) continue;
                    requirementFulfilled = true;
                    break;
                }
                if (requirementFulfilled &= combatGroup.getBlockers().size() >= Math.min((Integer)minNumberOfBlockersMap.get(toBeBlockedCreatureId), ((Set)mustBeBlockedByAtLeastX.get(toBeBlockedCreatureId)).size())) continue;
                if (controller.isHuman()) {
                    Permanent toBeBlockedCreature = game.getPermanent(toBeBlockedCreatureId);
                    if (toBeBlockedCreature == null) continue;
                    for (UUID possibleBlockerId : (Set)mustBeBlockedByAtLeastX.get(toBeBlockedCreatureId)) {
                        String string;
                        if (combatGroup.getBlockers().contains(possibleBlockerId) || (string = this.isCreatureDoingARequiredBlock(possibleBlockerId, toBeBlockedCreatureId, mustBeBlockedByAtLeastX, game)) == null) continue;
                        this.removeBlocker(possibleBlockerId, game);
                        controller.resetPlayerPassedActions();
                        game.informPlayer(controller, string + " Existing block removed. It's a requirement to block " + toBeBlockedCreature.getIdName() + '.');
                        return false;
                    }
                    continue;
                }
                for (UUID uUID : (Set)mustBeBlockedByAtLeastX.get(toBeBlockedCreatureId)) {
                    String blockRequiredMessage = this.isCreatureDoingARequiredBlock(uUID, toBeBlockedCreatureId, mustBeBlockedByAtLeastX, game);
                    if (blockRequiredMessage == null) continue;
                    Permanent permanent = game.getPermanent(uUID);
                    Player defender = game.getPlayer(permanent.getControllerId());
                    if (defender != null) {
                        if (permanent.getBlocking() > 0) {
                            this.removeBlocker(uUID, game);
                        }
                        defender.declareBlocker(defender.getId(), uUID, toBeBlockedCreatureId, game);
                    }
                    if (combatGroup.getBlockers().size() < (Integer)minNumberOfBlockersMap.get(toBeBlockedCreatureId)) continue;
                    continue block15;
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<UUID, Set<UUID>> entry : this.creatureMustBlockAttackers.entrySet()) {
            Permanent creatureForcedToBlock;
            boolean bl;
            block52: {
                bl = true;
                creatureForcedToBlock = game.getPermanent(entry.getKey());
                if (creatureForcedToBlock == null) break;
                if (!creatureForcedToBlock.isControlledBy(player.getId())) continue;
                if (creatureForcedToBlock.getBlocking() == 0) {
                    bl = entry.getValue().isEmpty();
                    for (UUID uUID : entry.getValue()) {
                        CombatGroup attackersGroup = game.getCombat().findGroup(uUID);
                        Permanent permanent = game.getPermanent(uUID);
                        if (attackersGroup == null || permanent == null || permanent.getMinBlockedBy() <= 1 || attackersGroup.getBlockers().size() + 1 >= permanent.getMinBlockedBy()) continue;
                        bl = true;
                    }
                } else {
                    bl = false;
                    for (CombatGroup combatGroup : game.getCombat().getGroups()) {
                        if (!combatGroup.getBlockers().contains(creatureForcedToBlock.getId())) continue;
                        for (UUID uUID : combatGroup.getAttackers()) {
                            if (entry.getValue().contains(uUID)) {
                                bl = true;
                            } else {
                                if (combatGroup.getBlockers().size() != 1 || !mustBeBlockedByAtLeastX.containsKey(uUID) || !((Set)mustBeBlockedByAtLeastX.get(uUID)).contains(creatureForcedToBlock.getId())) continue;
                                bl = true;
                            }
                            break block52;
                        }
                    }
                }
            }
            if (bl) continue;
            sb.append(' ').append(creatureForcedToBlock.getIdName());
        }
        if (sb.length() > 0) {
            if (controller.isHuman()) {
                controller.resetPlayerPassedActions();
                sb.insert(0, "Some creatures are forced to block certain attacker(s):\n");
                sb.append("\nPlease block with each of these creatures an appropriate attacker.");
                game.informPlayer(controller, sb.toString());
            }
            return false;
        }
        return true;
    }

    protected String isCreatureDoingARequiredBlock(UUID possibleBlockerId, UUID toBeBlockedCreatureId, Map<UUID, Set<UUID>> mustBeBlockedByAtLeastX, Game game) {
        Permanent possibleBlocker = game.getPermanent(possibleBlockerId);
        if (possibleBlocker != null) {
            Iterator<UUID> iterator;
            CombatGroup combatGroupOfPossibleBlocker;
            if (possibleBlocker.getBlocking() == 0) {
                return possibleBlocker.getIdName() + " does not block, but could block creatures with requirement to be blocked.";
            }
            Set<UUID> forcingAttackers = this.creatureMustBlockAttackers.get(possibleBlockerId);
            if (forcingAttackers == null && possibleBlocker.getBlocking() > 0 && (combatGroupOfPossibleBlocker = this.findGroupOfBlocker(possibleBlockerId)) != null && (iterator = combatGroupOfPossibleBlocker.getAttackers().iterator()).hasNext()) {
                UUID blockedAttackerId = iterator.next();
                if (mustBeBlockedByAtLeastX.containsKey(blockedAttackerId)) {
                    if (combatGroupOfPossibleBlocker.getBlockers().size() == 1) {
                        Set<UUID> blockedSet = mustBeBlockedByAtLeastX.get(blockedAttackerId);
                        Set<UUID> toBlockSet = mustBeBlockedByAtLeastX.get(toBeBlockedCreatureId);
                        if (toBlockSet == null) {
                            return null;
                        }
                        if (toBlockSet.containsAll(blockedSet)) {
                            return null;
                        }
                    }
                    Permanent blockedAttacker = game.getPermanent(blockedAttackerId);
                    return possibleBlocker.getIdName() + " blocks with other creatures " + blockedAttacker.getIdName() + ", which has to be blocked by only one creature. ";
                }
                Permanent blockedAttacker = game.getPermanent(blockedAttackerId);
                return possibleBlocker.getIdName() + " blocks " + blockedAttacker.getIdName() + ", which not has to be blocked as a requirement.";
            }
        }
        return null;
    }

    public boolean checkBlockRestrictionsAfter(Player player, Player controller, Game game) {
        RestrictionEffect effect;
        for (UUID blockingCreatureId : this.getBlockers()) {
            Permanent blockingCreature = game.getPermanent(blockingCreatureId);
            if (blockingCreature == null) continue;
            for (Map.Entry<RestrictionEffect, Set<Ability>> entry : game.getContinuousEffects().getApplicableRestrictionEffects(blockingCreature, game).entrySet()) {
                effect = entry.getKey();
                for (Ability ability : entry.getValue()) {
                    if (effect.canBlockCheckAfter(ability, game, true)) continue;
                    if (controller.isHuman()) {
                        controller.resetPlayerPassedActions();
                        game.informPlayer(controller, blockingCreature.getLogName() + " can't block this way.");
                        return false;
                    }
                    this.removeBlocker(blockingCreatureId, game);
                }
            }
        }
        for (UUID attackingCreatureId : this.getAttackers()) {
            Permanent attackingCreature = game.getPermanent(attackingCreatureId);
            if (attackingCreature == null) continue;
            for (Map.Entry<RestrictionEffect, Set<Ability>> entry : game.getContinuousEffects().getApplicableRestrictionEffects(attackingCreature, game).entrySet()) {
                effect = entry.getKey();
                for (Ability ability : entry.getValue()) {
                    if (effect.canBeBlockedCheckAfter(attackingCreature, ability, game, true)) continue;
                    if (controller.isHuman()) {
                        controller.resetPlayerPassedActions();
                        game.informPlayer(controller, attackingCreature.getLogName() + " can't be blocked this way.");
                        return false;
                    }
                    for (CombatGroup combatGroup : this.getGroups()) {
                        if (!combatGroup.getAttackers().contains(attackingCreatureId)) continue;
                        for (UUID blockerId : combatGroup.getBlockers()) {
                            this.removeBlocker(blockerId, game);
                        }
                    }
                }
            }
        }
        return true;
    }

    public void setDefenders(Game game) {
        for (UUID playerId : this.getAttackablePlayers(game)) {
            this.addDefendersFromPlayer(playerId, game);
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filterBattles, this.attackingPlayerId, game)) {
            this.defenders.add(permanent.getId());
        }
    }

    public List<UUID> getAttackablePlayers(Game game) {
        ArrayList<UUID> attackablePlayers = new ArrayList<UUID>();
        Player attackingPlayer = game.getPlayer(this.attackingPlayerId);
        if (attackingPlayer != null) {
            block0 : switch (game.getAttackOption()) {
                case LEFT: {
                    PlayerList players = game.getState().getPlayerList(this.attackingPlayerId);
                    Player opponent = players.getNext(game, false);
                    while (opponent != null && attackingPlayer.isInGame()) {
                        if (attackingPlayer.hasOpponent(opponent.getId(), game)) {
                            attackablePlayers.add(opponent.getId());
                            break block0;
                        }
                        opponent = players.getNext(game, false);
                    }
                    break;
                }
                case RIGHT: {
                    PlayerList players = game.getState().getPlayerList(this.attackingPlayerId);
                    Player opponent = players.getPrevious(game);
                    while (opponent != null && attackingPlayer.isInGame()) {
                        if (attackingPlayer.hasOpponent(opponent.getId(), game)) {
                            attackablePlayers.add(opponent.getId());
                            break block0;
                        }
                        opponent = players.getPrevious(game);
                    }
                    break;
                }
                case MULTIPLE: {
                    attackablePlayers.addAll(game.getOpponents(this.attackingPlayerId, true));
                }
            }
        }
        return attackablePlayers;
    }

    private void addDefendersFromPlayer(UUID playerId, Game game) {
        if (!this.defenders.contains(playerId)) {
            Player defendingPlayer;
            if (this.maxAttackers < Integer.MAX_VALUE && (defendingPlayer = game.getPlayer(playerId)) != null) {
                this.maxAttackers = defendingPlayer.getMaxAttackedBy() == Integer.MAX_VALUE ? Integer.MAX_VALUE : (this.maxAttackers == Integer.MIN_VALUE ? defendingPlayer.getMaxAttackedBy() : (this.maxAttackers += defendingPlayer.getMaxAttackedBy()));
            }
            this.defenders.add(playerId);
            for (Permanent permanent : game.getBattlefield().getAllActivePermanents(StaticFilters.FILTER_PERMANENT_PLANESWALKER, playerId, game)) {
                this.defenders.add(permanent.getId());
            }
        }
    }

    public boolean declareAttacker(UUID creatureId, UUID defenderId, UUID playerId, Game game) {
        Permanent attacker = game.getPermanent(creatureId);
        if (attacker == null || game.replaceEvent(new DeclareAttackerEvent(defenderId, creatureId, playerId)) || !this.addAttackerToCombat(creatureId, defenderId, game)) {
            return false;
        }
        if (attacker.hasAbility(VigilanceAbility.getInstance(), game) || attacker.hasAbility(JohanVigilanceAbility.getInstance(), game)) {
            return true;
        }
        if (!attacker.isTapped()) {
            attacker.setTapped(true);
            this.attackersTappedByAttack.add(attacker.getId());
        }
        return true;
    }

    public boolean addAttackerToCombat(UUID attackerId, UUID defenderId, Game game) {
        if (!this.defenders.contains(defenderId)) {
            return false;
        }
        Permanent defender = game.getPermanent(defenderId);
        if (!this.canDefenderBeAttacked(attackerId, defenderId, game)) {
            return false;
        }
        Permanent attacker = game.getPermanent(attackerId);
        if (attacker == null) {
            return false;
        }
        UUID defendingPlayerId = defender == null ? defenderId : (defender.isPlaneswalker(game) ? defender.getControllerId() : (defender.isBattle(game) ? defender.getProtectorId() : null));
        CombatGroup newGroup = new CombatGroup(defenderId, defender != null, defendingPlayerId);
        newGroup.attackers.add(attackerId);
        attacker.setAttacking(true);
        this.groups.add(newGroup);
        return true;
    }

    public boolean canDefenderBeAttacked(UUID attackerId, UUID defenderId, Game game) {
        Set<Object> defenderAttackedBy;
        Permanent defender = game.getPermanent(defenderId);
        if (defender != null) {
            return true;
        }
        Player defendingPlayer = game.getPlayer(defenderId);
        if (defendingPlayer == null) {
            return false;
        }
        if (this.numberCreaturesDefenderAttackedBy.containsKey(defendingPlayer.getId())) {
            defenderAttackedBy = this.numberCreaturesDefenderAttackedBy.get(defendingPlayer.getId());
        } else {
            defenderAttackedBy = new HashSet();
            this.numberCreaturesDefenderAttackedBy.put(defendingPlayer.getId(), defenderAttackedBy);
        }
        if (defenderAttackedBy.size() >= defendingPlayer.getMaxAttackedBy()) {
            Player attackingPlayer = game.getPlayer(game.getControllerId(attackerId));
            if (attackingPlayer != null && attackingPlayer.isHuman()) {
                attackingPlayer.resetPlayerPassedActions();
                game.informPlayer(attackingPlayer, "No more than " + CardUtil.numberToText(defendingPlayer.getMaxAttackedBy()) + " creatures can attack " + defendingPlayer.getLogName());
            }
            return false;
        }
        defenderAttackedBy.add(attackerId);
        return true;
    }

    public void addBlockingGroup(UUID blockerId, UUID attackerId, UUID playerId, Game game) {
        this.addBlockingGroup(blockerId, attackerId, playerId, game, true);
    }

    public void addBlockingGroup(UUID blockerId, UUID attackerId, UUID playerId, Game game, boolean solveBanding) {
        Permanent attacker;
        Permanent blocker = game.getPermanent(blockerId);
        if (blockerId != null && blocker != null && blocker.getBlocking() > 1) {
            if (!this.blockingGroupsContains(blockerId)) {
                CombatGroup newGroup = new CombatGroup(playerId, false, playerId);
                newGroup.blockers.add(blockerId);
                for (CombatGroup group : this.groups) {
                    if (!group.getBlockers().contains(blockerId)) continue;
                    newGroup.attackers.addAll(group.attackers);
                }
                this.blockingGroups.put(blockerId, newGroup);
            } else {
                this.blockingGroups.get((Object)blockerId).attackers.add(attackerId);
            }
        }
        if (solveBanding && (attacker = game.getPermanent(attackerId)) != null) {
            for (UUID bandedId : attacker.getBandedCards()) {
                if (bandedId.equals(attackerId) || this.blockingGroups.get(blockerId) != null && this.blockingGroups.get((Object)blockerId).attackers.contains(bandedId)) continue;
                Permanent banded = game.getPermanent(bandedId);
                CombatGroup bandedGroup = this.findGroup(bandedId);
                if (banded == null || bandedGroup == null) continue;
                bandedGroup.addBlockerToGroup(blockerId, playerId, game);
                this.addBlockingGroup(blockerId, bandedId, playerId, game, false);
                blocker.setBlocking(blocker.getBlocking() - 1);
            }
        }
    }

    public boolean removeDefendingPermanentFromCombat(UUID permanentId, Game game) {
        boolean result = false;
        for (CombatGroup group : this.groups) {
            if (group.getDefenderId() == null || !group.getDefenderId().equals(permanentId)) continue;
            group.removeAttackedPermanent(permanentId);
            result = true;
        }
        return result;
    }

    public boolean removeFromCombat(UUID creatureId, Game game, boolean withEvent) {
        Permanent creature = game.getPermanent(creatureId);
        if (creature == null) {
            return false;
        }
        boolean result = false;
        if (withEvent) {
            creature.setAttacking(false);
            creature.setBlocking(0);
        }
        for (CombatGroup group : this.groups) {
            for (UUID attackerId : group.attackers) {
                Permanent attacker = game.getPermanent(attackerId);
                if (attacker == null) continue;
                attacker.removeBandedCard(creatureId);
            }
            result |= group.remove(creatureId);
        }
        for (CombatGroup blockingGroup : this.getBlockingGroups()) {
            result |= blockingGroup.remove(creatureId);
        }
        creature.clearBandedCards();
        this.blockingGroups.remove(creatureId);
        if (result && withEvent) {
            game.fireEvent(GameEvent.getEvent(GameEvent.EventType.REMOVED_FROM_COMBAT, creatureId, null, null));
            game.informPlayers(creature.getLogName() + " removed from combat");
        }
        return result;
    }

    public void endCombat(Game game) {
        for (CombatGroup group : this.groups) {
            Permanent creature;
            for (UUID attacker : group.attackers) {
                creature = game.getPermanent(attacker);
                if (creature == null) continue;
                creature.setAttacking(false);
                creature.setBlocking(0);
                creature.clearBandedCards();
            }
            for (UUID blocker : group.blockers) {
                creature = game.getPermanent(blocker);
                if (creature == null) continue;
                creature.setAttacking(false);
                creature.setBlocking(0);
                creature.clearBandedCards();
            }
        }
        this.clear();
    }

    public boolean hasFirstOrDoubleStrike(Game game) {
        return this.groups.stream().anyMatch(group -> group.hasFirstOrDoubleStrike(game));
    }

    public CombatGroup findGroup(UUID attackerId) {
        for (CombatGroup group : this.groups) {
            if (!group.getAttackers().contains(attackerId)) continue;
            return group;
        }
        return null;
    }

    public CombatGroup findGroupOfBlocker(UUID blockerId) {
        for (CombatGroup group : this.groups) {
            if (!group.getBlockers().contains(blockerId)) continue;
            return group;
        }
        return null;
    }

    public boolean attacksAlone() {
        return this.groups.size() == 1 && this.groups.get(0).getAttackers().size() == 1;
    }

    public boolean noAttackers() {
        return this.groups.isEmpty() || this.getAttackers().isEmpty();
    }

    public boolean isPlaneswalkerAttacked(UUID defenderId, Game game) {
        for (CombatGroup group : this.groups) {
            Permanent permanent;
            if (!group.isDefenderIsPermanent() || !(permanent = game.getPermanent(group.getDefenderId())).isControlledBy(defenderId)) continue;
            return true;
        }
        return false;
    }

    public UUID getDefenderId(UUID attackerId) {
        return this.groups.stream().filter(group -> group.getAttackers().contains(attackerId)).map(CombatGroup::getDefenderId).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public UUID getDefendingPlayerId(UUID attackingCreatureId, Game game) {
        return this.getDefendingPlayerId(attackingCreatureId, game, true);
    }

    public UUID getDefendingPlayerId(UUID attackingCreatureId, Game game, boolean allowFormer) {
        if (allowFormer) {
            return Stream.concat(this.groups.stream(), this.formerGroups.stream()).filter(group -> group.getAttackers().contains(attackingCreatureId) || group.getFormerAttackers().contains(attackingCreatureId)).map(CombatGroup::getDefendingPlayerId).findFirst().orElse(null);
        }
        return this.groups.stream().filter(group -> group.getAttackers().contains(attackingCreatureId)).map(CombatGroup::getDefendingPlayerId).findFirst().orElse(null);
    }

    public Set<UUID> getPlayerDefenders(Game game) {
        return this.getPlayerDefenders(game, true);
    }

    public Set<UUID> getPlayerDefenders(Game game, boolean includePermanents) {
        HashSet<UUID> playerDefenders = new HashSet<UUID>();
        for (CombatGroup group : this.groups) {
            if (group.isDefenderIsPermanent() && !includePermanents) continue;
            if (group.isDefenderIsPermanent()) {
                Permanent permanent = game.getPermanent(group.getDefenderId());
                if (permanent == null) {
                    playerDefenders.add(group.getDefendingPlayerId());
                    continue;
                }
                if (permanent.isPlaneswalker(game)) {
                    playerDefenders.add(permanent.getControllerId());
                    continue;
                }
                if (!permanent.isBattle(game)) continue;
                playerDefenders.add(permanent.getProtectorId());
                continue;
            }
            playerDefenders.add(group.getDefenderId());
        }
        return playerDefenders;
    }

    public void removeAttacker(UUID attackerId, Game game) {
        for (CombatGroup group : this.groups) {
            if (!group.attackers.contains(attackerId)) continue;
            group.attackers.remove(attackerId);
            for (Set<UUID> attackingCreatures : this.numberCreaturesDefenderAttackedBy.values()) {
                attackingCreatures.remove(attackerId);
            }
            Permanent creature = game.getPermanent(attackerId);
            if (creature != null) {
                creature.setAttacking(false);
                if (this.attackersTappedByAttack.contains(creature.getId())) {
                    creature.setTapped(false);
                    this.attackersTappedByAttack.remove(creature.getId());
                }
            }
            if (group.attackers.isEmpty()) {
                this.formerGroups.add(group);
                this.groups.remove(group);
            }
            return;
        }
    }

    public void removeBlockerGromGroup(UUID blockerId, CombatGroup groupToUnblock, Game game) {
        Permanent creature = game.getPermanent(blockerId);
        if (creature != null) {
            ArrayList<CombatGroup> groupsToCheck = new ArrayList<CombatGroup>();
            for (CombatGroup group : this.groups) {
                if (!group.equals(groupToUnblock) || !group.blockers.contains(blockerId)) continue;
                groupsToCheck.add(group);
                for (UUID attackerId : group.getAttackers()) {
                    Permanent attacker = game.getPermanent(attackerId);
                    if (attacker == null) continue;
                    for (UUID bandedId : attacker.getBandedCards()) {
                        CombatGroup bandedGroup;
                        if (bandedId.equals(attackerId) || (bandedGroup = this.findGroup(bandedId)) == null) continue;
                        groupsToCheck.add(bandedGroup);
                    }
                }
            }
            for (CombatGroup group : groupsToCheck) {
                group.blockers.remove(blockerId);
                if (group.blockers.isEmpty()) {
                    group.blocked = false;
                }
                if (creature.getBlocking() > 0) {
                    if (group.equals(groupToUnblock)) {
                        creature.setBlocking(creature.getBlocking() - 1);
                    }
                } else {
                    throw new UnsupportedOperationException("Trying to unblock creature, but blocking number value of creature < 1");
                }
                boolean canRemove = false;
                for (CombatGroup blockGroup : this.getBlockingGroups()) {
                    if (blockGroup.blockers.contains(blockerId)) {
                        for (UUID attackerId : group.getAttackers()) {
                            blockGroup.attackers.remove(attackerId);
                        }
                        if (creature.getBlocking() == 0) {
                            blockGroup.blockers.remove(blockerId);
                        }
                    }
                    if (!blockGroup.blockers.isEmpty()) continue;
                    canRemove = true;
                }
                if (!canRemove) continue;
                this.blockingGroups.remove(blockerId);
            }
        }
    }

    public void removeBlocker(UUID blockerId, Game game) {
        Permanent permanent;
        for (CombatGroup combatGroup : this.groups) {
            if (!combatGroup.blockers.contains(blockerId)) continue;
            combatGroup.blockers.remove(blockerId);
            if (!combatGroup.blockers.isEmpty()) continue;
            combatGroup.blocked = false;
        }
        boolean canRemove = false;
        for (CombatGroup group : this.getBlockingGroups()) {
            if (group.blockers.contains(blockerId)) {
                group.blockers.remove(blockerId);
            }
            if (!group.blockers.isEmpty()) continue;
            canRemove = true;
        }
        if (canRemove) {
            this.blockingGroups.remove(blockerId);
        }
        if ((permanent = game.getPermanent(blockerId)) != null) {
            permanent.setBlocking(0);
        }
    }

    public UUID getAttackingPlayerId() {
        return this.attackingPlayerId;
    }

    public Map<UUID, Set<UUID>> getCreaturesForcedToAttack() {
        return this.creaturesForcedToAttack;
    }

    public int getMaxAttackers() {
        return this.maxAttackers;
    }

    @Override
    public Combat copy() {
        return new Combat(this);
    }

    public String toString() {
        ArrayList<String> res = new ArrayList<String>();
        for (int i = 0; i < this.groups.size(); ++i) {
            res.add(String.format("group %d with %s", i + 1, this.groups.get(i)));
        }
        return String.format("%d groups%s", this.groups.size(), this.groups.size() > 0 ? ": " + String.join((CharSequence)"; ", res) : "");
    }

    static {
        filterBattles.add(ProtectedByOpponentPredicate.instance);
    }
}

