/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.dungeons;

import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.abilities.effects.common.LoseLifeOpponentsEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.abilities.effects.keyword.ScryEffect;
import mage.constants.Duration;
import mage.counters.CounterType;
import mage.game.command.Dungeon;
import mage.game.command.DungeonRoom;
import mage.game.permanent.token.GoblinToken;
import mage.game.permanent.token.TreasureToken;
import mage.target.common.TargetCreaturePermanent;

public class LostMineOfPhandelverDungeon
extends Dungeon {
    public LostMineOfPhandelverDungeon() {
        super("Lost Mine of Phandelver");
        DungeonRoom caveEntrance = new DungeonRoom("Cave Entrance", new ScryEffect(1, false));
        DungeonRoom goblinLair = new DungeonRoom("Goblin Lair", new CreateTokenEffect(new GoblinToken()));
        DungeonRoom mineTunnels = new DungeonRoom("Mine Tunnels", new CreateTokenEffect(new TreasureToken()));
        DungeonRoom storeroom = new DungeonRoom("Storeroom", new AddCountersTargetEffect(CounterType.P1P1.createInstance()));
        storeroom.addTarget(new TargetCreaturePermanent());
        DungeonRoom darkPool = new DungeonRoom("Dark Pool", new LoseLifeOpponentsEffect(1), new GainLifeEffect(1).concatBy("and"));
        DungeonRoom fungiCavern = new DungeonRoom("Fungi Cavern", new BoostTargetEffect(-4, 0, Duration.UntilYourNextTurn));
        fungiCavern.addTarget(new TargetCreaturePermanent());
        DungeonRoom templeOfDumathoin = new DungeonRoom("Temple of Dumathoin", new DrawCardSourceControllerEffect(1));
        caveEntrance.addNextRoom(goblinLair);
        caveEntrance.addNextRoom(mineTunnels);
        goblinLair.addNextRoom(storeroom);
        goblinLair.addNextRoom(darkPool);
        mineTunnels.addNextRoom(darkPool);
        mineTunnels.addNextRoom(fungiCavern);
        storeroom.addNextRoom(templeOfDumathoin);
        darkPool.addNextRoom(templeOfDumathoin);
        fungiCavern.addNextRoom(templeOfDumathoin);
        this.addRoom(caveEntrance);
        this.addRoom(goblinLair);
        this.addRoom(mineTunnels);
        this.addRoom(storeroom);
        this.addRoom(darkPool);
        this.addRoom(fungiCavern);
        this.addRoom(templeOfDumathoin);
    }

    private LostMineOfPhandelverDungeon(LostMineOfPhandelverDungeon dungeon) {
        super(dungeon);
    }

    @Override
    public LostMineOfPhandelverDungeon copy() {
        return new LostMineOfPhandelverDungeon(this);
    }
}

