/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.dungeons;

import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class RunestoneCavernsEffect
extends OneShotEffect {
    RunestoneCavernsEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top two cards of your library. You may play them";
    }

    private RunestoneCavernsEffect(RunestoneCavernsEffect effect) {
        super(effect);
    }

    @Override
    public RunestoneCavernsEffect copy() {
        return new RunestoneCavernsEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 2));
        if (cards.isEmpty()) {
            return false;
        }
        player.moveCards(cards, Zone.EXILED, source, game);
        while (!cards.isEmpty()) {
            for (Card card : cards.getCards(game)) {
                if (!player.chooseUse(Outcome.PlayForFree, "Play " + card.getName() + "?", source, game)) continue;
                game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), Boolean.TRUE);
                player.cast(player.chooseAbilityForCast(card, game, false), game, false, new ApprovingObject(source, game));
                game.getState().setValue("PlayFromNotOwnHandZone" + card.getId(), null);
            }
            cards.retainZone(Zone.EXILED, game);
            if (!cards.isEmpty() && player.chooseUse(Outcome.PlayForFree, "Continue playing the exiled cards?", source, game)) continue;
            break;
        }
        return true;
    }
}

