/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.emblems;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Mode;
import mage.abilities.SpellAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.command.emblems.DackFaydenEmblemEffect;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.Target;

class DackFaydenEmblemTriggeredAbility
extends TriggeredAbilityImpl {
    DackFaydenEmblemTriggeredAbility() {
        super(Zone.COMMAND, new DackFaydenEmblemEffect(), false);
    }

    DackFaydenEmblemTriggeredAbility(DackFaydenEmblemTriggeredAbility ability) {
        super(ability);
    }

    @Override
    public DackFaydenEmblemTriggeredAbility copy() {
        return new DackFaydenEmblemTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell;
        boolean returnValue = false;
        ArrayList<UUID> targetedPermanentIds = new ArrayList<UUID>();
        Player player = game.getPlayer(this.getControllerId());
        if (player != null && event.getPlayerId().equals(this.getControllerId()) && (spell = game.getStack().getSpell(event.getTargetId())) != null) {
            SpellAbility spellAbility = spell.getSpellAbility();
            for (UUID modeId : spellAbility.getModes().getSelectedModes()) {
                Mode mode = spellAbility.getModes().get(modeId);
                for (Target target : mode.getTargets()) {
                    if (target.isNotTarget()) continue;
                    for (UUID targetId : target.getTargets()) {
                        if (!game.getBattlefield().containsPermanent(targetId)) continue;
                        returnValue = true;
                        targetedPermanentIds.add(targetId);
                    }
                }
            }
            for (Effect effect : spellAbility.getEffects()) {
                for (UUID targetId : effect.getTargetPointer().getTargets(game, spellAbility)) {
                    if (!game.getBattlefield().containsPermanent(targetId)) continue;
                    returnValue = true;
                    targetedPermanentIds.add(targetId);
                }
            }
        }
        for (Effect effect : this.getEffects()) {
            if (!(effect instanceof DackFaydenEmblemEffect)) continue;
            DackFaydenEmblemEffect dackEffect = (DackFaydenEmblemEffect)effect;
            ArrayList<Permanent> permanents = new ArrayList<Permanent>();
            for (UUID permanentId : targetedPermanentIds) {
                Permanent permanent = game.getPermanent(permanentId);
                if (permanent == null) continue;
                permanents.add(permanent);
            }
            dackEffect.setTargets(permanents, game);
        }
        return returnValue;
    }

    @Override
    public String getRule() {
        return "Whenever you cast a spell that targets one or more permanents, gain control of those permanents.";
    }
}

