/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.emblems;

import mage.abilities.TriggeredAbilityImpl;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.command.emblems.DarettiScrapSavantEffect;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.target.targetpointer.FixedTarget;

class DarettiScrapSavantTriggeredAbility
extends TriggeredAbilityImpl {
    DarettiScrapSavantTriggeredAbility() {
        super(Zone.COMMAND, new DarettiScrapSavantEffect(), false);
        this.setTriggerPhrase("Whenever an artifact is put into your graveyard from the battlefield, ");
    }

    DarettiScrapSavantTriggeredAbility(DarettiScrapSavantTriggeredAbility ability) {
        super(ability);
    }

    @Override
    public DarettiScrapSavantTriggeredAbility copy() {
        return new DarettiScrapSavantTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.isDiesEvent() && zEvent.getTarget().isArtifact(game) && zEvent.getTarget().isOwnedBy(this.controllerId)) {
            this.getEffects().setTargetPointer(new FixedTarget(zEvent.getTargetId(), game));
            return true;
        }
        return false;
    }
}

