/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.emblems;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionUntapNotMoreThanEffect;
import mage.constants.Duration;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class DovinBaanCantUntapEffect
extends RestrictionUntapNotMoreThanEffect {
    DovinBaanCantUntapEffect() {
        super(Duration.WhileOnBattlefield, 2, StaticFilters.FILTER_CONTROLLED_PERMANENT);
        this.staticText = "Your opponents can't untap more than two permanents during their untap steps.";
    }

    DovinBaanCantUntapEffect(DovinBaanCantUntapEffect effect) {
        super(effect);
    }

    @Override
    public boolean applies(Player player, Ability source, Game game) {
        return game.getOpponents(source.getControllerId()).contains(player.getId());
    }

    @Override
    public DovinBaanCantUntapEffect copy() {
        return new DovinBaanCantUntapEffect(this);
    }
}

